<?php
class ControllerExtensionModuleGoogleTranslate extends Controller {

    private $mName 			= 'module_google_translate';
    private $mPath 		    = 'extension/module/google_translate';
    private $mVersion 		= '1.2';

    public function index() {
        $data['ga_status'] = (int)$this->config->get('module_google_translate_status');
        $data['ga_language'] = $this->config->get('module_google_translate_language');
        $data['ga_specific'] = (int)$this->config->get('module_google_translate_specific');
        $data['ga_languages'] = is_array($this->config->get('module_google_translate_languages')) ? implode(',', $this->config->get('module_google_translate_languages')) : array();
        $data['ga_multiple'] = (int)$this->config->get('module_google_translate_multiple');
        $data['ga_track'] = (int)$this->config->get('module_google_translate_track');
        $data['analytics_id'] = $this->config->get('module_google_translate_analytics_id');
        $data['ga_view'] = (int)$this->config->get('module_google_translate_view');
        $data['ga_logo'] = (int)$this->config->get('module_google_translate_logo');
        $data['ga_bar'] = (int)$this->config->get('module_google_translate_bar');
        $data['ga_class'] = $this->config->get('module_google_translate_class');
        $data['ga_style'] = $this->config->get('module_google_translate_style');
        $data['ga_label'] = $this->config->get('module_google_translate_label');

        if (!isset($_COOKIE['googtrans']) && $this->config->get('module_google_translate_start_language')) {
            $result = parse_url(HTTP_SERVER);
            setcookie('googtrans', '', 0, '', $result['host']);
            setcookie('googtrans', '', 0, '', '.' . $result['host']);
            setcookie('googtrans', '/' . $this->config->get('module_google_translate_start_language'), time() + 525600, '', $result['host']);
        }

        $data['ga_icon'] = $this->config->get('module_google_translate_language_icon');
        $data['ga_start'] = $this->config->get('module_google_translate_start_language') ? isset($_COOKIE['googtrans']) ? 0 : $this->config->get('module_google_translate_start_language') : 0;
        return $this->load->view($this->mPath, $data);
    }
}