<?php

/**
 * @license Commercial
 * @author info@ocdemo.eu
 * 
 * All code within this file is copyright OC Mega Extensions.
 * You may not copy or reuse code within this file without written permission. 
 */

abstract class ControllerModuleMRewardPointsCronAbstract extends Controller {
	
	private $_name = 'mreward_points';
	
	private $logs = array();
	
	////////////////////////////////////////////////////////////////////////////
	
	protected function module_path( $p = null ) {
		/* @var $path string */
		$path = 'module/' . $this->_name;
		
		if( version_compare( VERSION, '3', '>=' ) ) {
			$path = 'extension/' . $path;
		}
		
		return $path . ( $p ? '/' . $p : '' );
	}

	public function index() {
		/* @var $settings array */
		$settings = $this->config->get( $this->_name.'_reminder' );
		
		if( ! $settings || empty( $settings['cron_status'] ) ) {
			return $this->out( 'Cron is disabled' );
		}
				
		if( ! isset( $this->request->get['code'] ) || $this->request->get['code'] != $settings['secret_code'] ) {
			return $this->out( 'Secret Code is invalid' );
		}
		
		foreach( $settings['reminder_content'] as $check_lang ){
			if( empty( $check_lang['reminder_title'] ) || empty( $check_lang['reminder_title'] ) ) {
				return $this->out( 'ERROR - The subject and content of the e-mails are required for every languages.' );
			}
		}

		/* @var $file string */
		$file = DIR_LOGS . 'mrp_reviews_cron.log';
		
		//////////////////////////////////////////////////////////////////////////
		
		/* @var $total_dispatched int */
		$total_dispatched = 0;
		
		/* @var $order_ids array */
		$order_ids = array();

		if( ! empty( $settings['order_status_send_ids'] ) ){
			/* @var $bonuses array */
			$bonuses = $this->config->get( $this->_name.'_bonuses' );
			
			/* @var $reminder_days_delayed int */
			$reminder_days_delayed = isset($settings['reminder_days_delayed']) ? (int) $settings['reminder_days_delayed'] : 0;
			
			/* @var $date_type string */
			$date_type = isset($settings['reminder_date_type']) && $settings['reminder_date_type'] ? 'date_added' : 'date_modified';
			
			/* @var $final_data_reminders */
			$final_data_reminders = array();
			
			if( $settings['grouping_pending_reminders'] ){
				/* @var $conditions array */
				$conditions = array(
					"`product_review_reminder` = 0",
					"DATE( DATE_ADD(" . $date_type . ", INTERVAL " . $reminder_days_delayed . " DAY)) <= CURDATE()",
					"`order_status_id` IN (" . implode(',', $settings['order_status_send_ids']) . ")"
				);
				
				if( ! empty( $settings['for_orders_created_after'] ) ) {
					$conditions[] = "`date_added` >= '" . $this->db->escape( $settings['for_orders_created_after'] ) . "'";
				}
				
				/* @var $sql string */
				$sql = "
					SELECT 
						* 
					FROM 
						`" . DB_PREFIX . "order` 
					WHERE 
						" . implode( ' AND ', $conditions ) . "
					LIMIT
						5000
				";
				
				$reminders = $this->db->query( $sql );
			
				foreach( $reminders->rows as $user_order_row ){
					$final_data_reminders[$user_order_row['customer_id']]['order_ids'][] = $user_order_row['order_id'];
					$final_data_reminders[$user_order_row['customer_id']]['firstname'] = $user_order_row['firstname'];
					$final_data_reminders[$user_order_row['customer_id']]['lastname'] = $user_order_row['lastname'];
					$final_data_reminders[$user_order_row['customer_id']]['email'] = $user_order_row['email'];
					$final_data_reminders[$user_order_row['customer_id']]['store_name'] = $user_order_row['store_name'];
					$order_ids[] = $user_order_row['order_id'];
				}
			}		
			
			if( $final_data_reminders ) {
				$this->load->model('checkout/order');
				
				/* @var $lang int */
				$lang = (int)$this->config->get('config_language_id');
		
				if( version_compare( VERSION, '3', '>=' ) ) {
					$mail = new Mail($this->config->get('config_mail_engine'));
					$mail->parameter = $this->config->get('config_mail_parameter');
					$mail->smtp_hostname = $this->config->get('config_mail_smtp_hostname');
					$mail->smtp_username = $this->config->get('config_mail_smtp_username');
					$mail->smtp_password = html_entity_decode($this->config->get('config_mail_smtp_password'), ENT_QUOTES, 'UTF-8');
					$mail->smtp_port = $this->config->get('config_mail_smtp_port');
					$mail->smtp_timeout = $this->config->get('config_mail_smtp_timeout');
				} else if( null != ( $config_mail = $this->config->get('config_mail') ) && is_array( $config_mail ) && isset( $config_mail['protocol'] ) ) {
					$mail = new Mail($this->config->get('config_mail'));
				} else {
					$mail = new Mail();
					$mail->protocol = $this->config->get('config_mail_protocol');
					$mail->parameter = $this->config->get('config_mail_parameter');
					$mail->smtp_hostname = $this->config->get('config_mail_smtp_hostname')?$this->config->get('config_mail_smtp_hostname'):$this->config->get('config_mail_smtp_host');
					$mail->smtp_username = $this->config->get('config_mail_smtp_username');
					$mail->smtp_password = html_entity_decode($this->config->get('config_mail_smtp_password'), ENT_QUOTES, 'UTF-8');
					$mail->smtp_port = $this->config->get('config_mail_smtp_port');
					$mail->smtp_timeout = $this->config->get('config_mail_smtp_timeout');
				}
				
				$mail->setFrom($this->config->get('config_email'));

				foreach( $final_data_reminders as $reminder ) {
					/* @var $order_lang int */
					$order_lang = isset($reminder['language_id']) ? $reminder['language_id'] : $lang;

					/* @var $subject string */
					$subject = $settings['reminder_content'][$order_lang]['reminder_title'];
					
					/* @var $find array */
					$find = array(
						'{order_id}',
						'{review_bonus_points}',
						'{review_limit}',
						'{first_name}',
						'{last_name}'
					);

					/* @var $replaceTo array */
					$replaceTo = array(
						'order_ids'				=> ($settings['grouping_pending_reminders'] ? implode(", ", $reminder['order_ids']) : $reminder['order_id']),
						'review_bonus_points'   => $bonuses['on_product_review'],
						'review_limit'			=> $bonuses['product_review_limit'],
						'first_name'			=> $reminder['firstname'],
						'last_name'				=> $reminder['lastname']
					);

					/* @var $message string */
					$message = $settings['reminder_content'][$order_lang]['description'];
					$message = str_replace(array("\r\n", "\r", "\n"), '<br />', preg_replace(array("/\s\s+/", "/\r\r+/", "/\n\n+/"), '<br />', trim(str_replace($find, $replaceTo, $message))));

					/* @var $store_name string */
					$store_name = isset($reminder['store_name']) ? $reminder['store_name'] : $this->config->get('config_name');

					$mail->setSender($store_name);
					$mail->setTo($reminder['email']);
					$mail->setSubject(html_entity_decode($subject, ENT_QUOTES, 'UTF-8'));
					$mail->setHtml(html_entity_decode($message, ENT_QUOTES, 'UTF-8'));
					$mail->send();

					if( $settings['grouping_pending_reminders'] ){
						if( $reminder['order_ids'] ) {
							$this->db->query("UPDATE `" . DB_PREFIX . "order` SET product_review_reminder = '1' WHERE order_id IN(" . implode( ',', $reminder['order_ids'] ) . ")");
						}
					} else {
						$this->db->query("UPDATE `" . DB_PREFIX . "order` SET product_review_reminder = '1' WHERE order_id = '" . $reminder['order_id'] . "'");
					
						$order_ids[] = $reminder['order_id'];
					}
					
					$total_dispatched += 1;	
				}
			}
					
			$this->logs[] = 'Last run dispatched '. $total_dispatched .' E-Mailst to orders (id): '. implode(', ', $order_ids).'. Run time: '. date("Y-m-d H:i:s")."\r\n";
			
			if( ! empty( $settings['cron_logs_status'] ) ) {
				file_put_contents($file, end( $this->logs ), FILE_APPEND|LOCK_EX);
			}
		} else {
			$this->logs[] = 'Please select statuses on which the reminder should be send.';
		}
		
		return $this->out();
	}
	
	private function out( $log = null, $echo = true ) {
		if( ! is_null( $log ) ) {
			$this->logs[] = $log;
		}
		
		$out = implode( "\n", $this->logs );
		
		if( ! $echo ) {
			return $out;
		}
		
		echo $out;
	}
	
	private function pointsByCustomerId( $customer_id ) {
		return $this->db->query("SELECT SUM(`points`) AS `total` FROM `" . DB_PREFIX . "customer_reward` WHERE `customer_id` = " . (int) $customer_id)->row['total'];
	}
	
	public function cron_reward_points() {
		/* @var $settings array */
		$settings = $this->config->get( $this->_name.'_expiry_reminder' );
		
		if( ! $settings || empty( $settings['cron_status'] ) ) {
			return $this->out( 'Cron is disabled' );
		}
				
		if( ! isset( $this->request->get['code'] ) || $this->request->get['code'] != $settings['secret_code'] ) {
			return $this->out( 'Secret Code is invalid' );
		}

		/* @var $file strin */
		$file = DIR_LOGS . 'mrp_expiry_points_cron.log';
		
		//////////////////////////////////////////////////////////////////////////
		
		/* @var $total_dispatched int */
		$total_dispatched = 0;

		if( $settings['reminder_status'] && $settings['reminder_days_lose'] ) {
			foreach ($settings['reminder_content'] as $check_lang){
				if( empty($check_lang['reminder_title']) || empty($check_lang['reminder_title']) ) {
					return $this->out('ERROR - The subject and content of the e-mails are required for every languages.');
				}
			}
			
			/* @var $reminder_days_lose int */
			$reminder_days_lose = (int) $settings['reminder_days_lose'];
			
			/* @var $reminder_days_interval int */
			$reminder_days_interval = (int) $settings['reminder_days_interval'];
			
			/* @var $conditions array */
			$conditions = array(
				"DATE( DATE_ADD(`date_added`, INTERVAL " . ( $reminder_days_lose + $reminder_days_interval ) . " DAY) ) BETWEEN CURDATE()",
				"DATE( DATE_ADD(CURDATE(), INTERVAL " . $reminder_days_interval . " DAY) )",
				"`points` > 0",
				"`rewards_reminder` != 1"
			);
				
			if( ! empty( $settings['for_rewards_created_after'] ) ) {
				$conditions[] = "`date_added` >= '" . $this->db->escape( $settings['for_rewards_created_after'] ) . "'";
			}

			/* @var $sql string */
			$sql = "
				SELECT 
					* 
				FROM 
					`" . DB_PREFIX . "customer_reward` 
				WHERE 
					" . implode( ' AND ', $conditions );
			
			/* @var $reminders \stdClass */
			$reminders = $this->db->query( $sql );

			/* @var $final_data_reminders */
			$final_data_reminders = array();

			/* @var $user_rewards_row array */
			foreach( $reminders->rows as $user_rewards_row ){
				$final_data_reminders[$user_rewards_row['customer_id']]['customer_reward_ids'][] = $user_rewards_row['customer_reward_id'];
				$final_data_reminders[$user_rewards_row['customer_id']]['order_ids'][] = $user_rewards_row['order_id'];
				$final_data_reminders[$user_rewards_row['customer_id']]['description'][] = $user_rewards_row['points'] . ' - ' . $user_rewards_row['description'];
				$final_data_reminders[$user_rewards_row['customer_id']]['points'][] = $user_rewards_row['points'];
			}

			if( $final_data_reminders ) {
				$this->load->model('account/customer');
				$this->load->model('checkout/order');

				/* @var $lang int */
				$lang = (int)$this->config->get('config_language_id');

				if( version_compare( VERSION, '3', '>=' ) ) {
					$mail = new Mail($this->config->get('config_mail_engine'));
					$mail->protocol = $this->config->get('config_mail_protocol');
					$mail->parameter = $this->config->get('config_mail_parameter');
					$mail->smtp_hostname = $this->config->get('config_mail_smtp_hostname');
					$mail->smtp_username = $this->config->get('config_mail_smtp_username');
					$mail->smtp_password = html_entity_decode($this->config->get('config_mail_smtp_password'), ENT_QUOTES, 'UTF-8');
					$mail->smtp_port = $this->config->get('config_mail_smtp_port');
					$mail->smtp_timeout = $this->config->get('config_mail_smtp_timeout');
				} else if( null != ( $config_mail = $this->config->get('config_mail') ) && is_array( $config_mail ) && isset( $config_mail['protocol'] ) ) {
					$mail = new Mail($this->config->get('config_mail'));
				} else {
					$mail = new Mail();
					$mail->protocol = $this->config->get('config_mail_protocol');
					$mail->parameter = $this->config->get('config_mail_parameter');
					$mail->smtp_hostname = $this->config->get('config_mail_smtp_hostname')?$this->config->get('config_mail_smtp_hostname'):$this->config->get('config_mail_smtp_host');
					$mail->smtp_username = $this->config->get('config_mail_smtp_username');
					$mail->smtp_password = html_entity_decode($this->config->get('config_mail_smtp_password'), ENT_QUOTES, 'UTF-8');
					$mail->smtp_port = $this->config->get('config_mail_smtp_port');
					$mail->smtp_timeout = $this->config->get('config_mail_smtp_timeout');
				}

				$mail->setFrom($this->config->get('config_email'));

				/* @var $reminder array */
				foreach( $final_data_reminders as $customer_id => $reminder ) {
					/* @var $order_info array */
					$order_info = $this->model_checkout_order->getOrder($reminder['order_ids'][0]);

					/* @var $order_lang int */
					$order_lang = isset($order_info['language_id']) ? $order_info['language_id'] : $lang;

					/* @var $store_name string */
					$store_name = isset($order_info['store_name']) ? $order_info['store_name'] : $this->config->get('config_name');

					/* @var $customer array */
					$customer = $this->model_account_customer->getCustomer($customer_id);

					/* @var $subject string */
					$subject = $settings['reminder_content'][$order_lang]['reminder_title'];
					
					/* @var $points int */
					if( 0 < ( $points = $this->pointsByCustomerId( $customer_id ) ) ) {
						/* @var $message string */
						$message = $settings['reminder_content'][$order_lang]['description'];
						$message = str_replace(
							array(
								"\r\n", 
								"\r", 
								"\n"
							), 
							'<br />', 
							preg_replace(
								array(
									"/\s\s+/", 
									"/\r\r+/", 
									"/\n\n+/"
								), 
								'<br />', 
								trim(
									str_replace(
										array(
											'{order_bonuses_pionts}', 
											'{amount_of_points}'
										), 
										array(
											implode("<br>", $reminder['description']), 
											$points
										), 
										$message
									)
								)
							)
						);

						$mail->setSender($store_name);
						$mail->setTo($customer['email']);
						$mail->setSubject(html_entity_decode($subject, ENT_QUOTES, 'UTF-8'));
						$mail->setHtml(html_entity_decode($message, ENT_QUOTES, 'UTF-8'));
						$mail->send();
					}

					if( $reminder['customer_reward_ids'] ) {
						$this->db->query("
							UPDATE 
								`" . DB_PREFIX . "customer_reward` 
							SET 
								`rewards_reminder` = '1' 
							WHERE 
								`customer_reward_id` IN(" . implode( ',', $reminder['customer_reward_ids'] ) . ')'
						);
					}

					$total_dispatched += 1;	
				}
			}
					
			$this->logs[] = 'Last run dispatched '. $total_dispatched .' E-Mails to customers (id): '. implode(", ", array_keys($final_data_reminders)).'. Run time: '. date("Y-m-d H:i:s");

			if( ! empty( $settings['cron_logs_status'] ) ) {
				file_put_contents($file, end( $this->logs ), FILE_APPEND|LOCK_EX);
			}
		} else {
			$this->logs[] = 'Reward points expiry reminder is disabled or points are unlimited.';
		}
		
		/* delete section */
		if( $settings['reminder_days_delayed'] ) {
			$this->language->load( $this->module_path() );
			
			/* @var $deleted int */
			$deleted = 0;
			
			/* @var $limit int */
			$limit = 100;
			
			/* @var $points_per_customer array */
			$points_per_customer = array();
			
			/* @var $row array */
			foreach( $this->db->query("
					SELECT 
						`customer_id`,
						SUM(`points`) AS `points`
					FROM 
						`" . DB_PREFIX . "customer_reward` 
					WHERE
						( DATE_ADD(`date_added`, INTERVAL " . (int) $settings['reminder_days_delayed'] . " DAY) < NOW() OR `points` < 0 )
					GROUP BY
						`customer_id`
					HAVING
						`points` > 0
					LIMIT
						" . $limit . "
				")->rows as $row 
			) {
				$points_per_customer[$row['customer_id']] = $row['points'];
			}
			
			if( $points_per_customer ) {
				/* @var $row array */
				foreach( $this->db->query("
						SELECT 
							*
						FROM 
							`" . DB_PREFIX . "customer_reward` 
						WHERE
							DATE_ADD(`date_added`, INTERVAL " . (int) $settings['reminder_days_delayed'] . " DAY) < NOW()
								AND
							`expired` = 0
								AND
							`points` > 0
								AND
							`customer_id` IN(" . implode( ',', array_keys( $points_per_customer ) ) . ")
						ORDER BY
							`customer_id` ASC,
							`customer_reward_id` DESC
					")->rows as $row 
				) {
					$points = $row['points'];

					if( $points_per_customer[$row['customer_id']] - $points < 0 ) {
						$points -= $points_per_customer[$row['customer_id']];
					} else {
						$points -= $points;
					}

					/* @var $sql string */
					$sql = "
						UPDATE 
							`" . DB_PREFIX . "customer_reward` 
						SET 
							`description` = '" . $this->db->escape( 
								$row['description'] . ( $row['points'] - $points ? ' ('. $this->language->get('text_points_expired') . ' ' . ( $row['points'] - $points ) . ')' : '' ) 
							) . "', 
							`points` = " . $points . ",
							`expired` = 1
						WHERE 
							`customer_reward_id` = '" . (int)$row['customer_reward_id'] . "'
					";

					$this->db->query( $sql );

					$points_per_customer[$row['customer_id']] -= $row['points'] - $points;

					$deleted += $row['points'] - $points;
				}
			}

			$this->logs[] = 'Last run removed '. $deleted .' reward records. Run time: '. date("Y-m-d H:i:s");
			
			if( ! empty( $settings['cron_logs_status'] ) ) {
				file_put_contents($file, end( $this->logs ), FILE_APPEND|LOCK_EX);
			}
		} else {
			$this->logs[] = 'Period of validity of points is unlimited.';
		}

		return $this->out();
	}
}