<?php
class ModelExtensionModuleSmm extends Model {
    use OCM\Traits\Back\Model\Product;
    public function addDBTables() {
        $sql = "
            CREATE TABLE IF NOT EXISTS `".DB_PREFIX."smm` (
              `id` int(8) NOT NULL AUTO_INCREMENT,
              `method_data` MEDIUMTEXT NULL,
              `code` VARCHAR(32) NOT NULL,
               PRIMARY KEY (`id`)
            ) ENGINE=MyISAM  DEFAULT CHARSET=utf8;
        ";
        $query = $this->db->query($sql);
    }
    public function addData($data) {
        $row_exist = $this->db->query("SELECT * FROM `" . DB_PREFIX . "smm` WHERE code = '" . $this->db->escape($data['code']) . "'")->row;
        if ($row_exist) {
            $sql = "UPDATE `" . DB_PREFIX . "smm` SET method_data= '" . $this->db->escape($data['method_data']) . "'";
            $sql .= " WHERE code = '" . $this->db->escape($data['code']) . "'";
        } else {
            $sql = "INSERT INTO `" .DB_PREFIX . "smm` SET method_data= '" . $this->db->escape($data['method_data']) . "', code = '" . $this->db->escape($data['code']) . "'";
        }
        $this->db->query($sql);
        return true;
    }
    public function getData() {
        $return = array();
        $rows = $this->db->query("SELECT * FROM `" . DB_PREFIX . "smm` ORDER BY code ASC")->rows;
        foreach ($rows as $key => $value) {
            $method_data = $value['method_data'];
            $method_data = json_decode($method_data, true);
            if (!is_array($method_data)) $method_data = array();
            $code = $value['code'];
            $return[$code] = $method_data;
        }
        return $return;
    }
    public function deleteAll() {
        $this->db->query("DELETE FROM `" . DB_PREFIX . "smm`");
    }
}