function initTemplate() {
    'use strict';

    var elements = stripe.elements({
        fonts: [
            {
                cssSrc: 'https://fonts.googleapis.com/css?family=Source+Code+Pro'
            }
        ],
        locale: 'auto'
    });

    // Floating labels
    var inputs = document.querySelectorAll('.cell.example.example2 .input');
    Array.prototype.forEach.call(inputs, function(input) {
        input.addEventListener('focus', function() {
            input.classList.add('focused');
        });
        input.addEventListener('blur', function() {
            input.classList.remove('focused');
        });
        input.addEventListener('keyup', function() {
            if (input.value.length === 0) {
                input.classList.add('empty');
            } else {
                input.classList.remove('empty');
            }
        });
    });

    var elementStyles = {
        base: {
            color: '#32325D',
            fontWeight: 500,
            fontFamily: 'Source Code Pro, Consolas, Menlo, monospace',
            fontSize: '16px',
            fontSmoothing: 'antialiased',

            '::placeholder': {
                color: '#CFD7DF'
            },
            ':-webkit-autofill': {
                color: '#e39f48'
            }
        },
        invalid: {
            color: '#E25950',

            '::placeholder': {
                color: '#FFCCA5'
            }
        }
    };

    var elementClasses = {
        focus: 'focused',
        empty: 'empty',
        invalid: 'invalid'
    };

    var cardNumber = elements.create('cardNumber', {
        style: elementStyles,
        classes: elementClasses
    });
    cardNumber.mount('#example2-card-number');

    var cardExpiry = elements.create('cardExpiry', {
        style: elementStyles,
        classes: elementClasses
    });
    cardExpiry.mount('#example2-card-expiry');

    var cardCvc = elements.create('cardCvc', {
        style: elementStyles,
        classes: elementClasses
    });
    cardCvc.mount('#example2-card-cvc');

    registerElements([cardNumber, cardExpiry, cardCvc], 'example2');
}


function initTemplateSafe() {
    stripe != null ? initTemplate()
        : setTimeout(function() { initTemplateSafe() }, 50);
}
initTemplateSafe();
