<?php 
class ModelExtensionModuleXcoupon extends Model {
    use OCM\Traits\Front\Address;
    use OCM\Traits\Front\Common_params;
    use OCM\Traits\Front\Product;
    use OCM\Traits\Front\Validator;
    use OCM\Traits\Front\Equation;
    use OCM\Traits\Front\Crucify;
    use OCM\Traits\Front\Util;
    private $ext_path;
    private $mtype;
    private $mname;
    public function __construct($registry) {
        parent::__construct($registry);
        $this->registry = $registry;
        $this->ocm = ($ocm = $this->registry->get('ocm_front')) ? $ocm : new OCM\Front($this->registry);
        $this->mtype = 'module';
        $this->mname = 'xcoupon';
        $this->ext_path = 'extension/module/xcoupon';
    }
    public function getTotal() {
        $xcoupon_status = $this->ocm->getConfig('xcoupon_status', $this->mtype);
        if (!$xcoupon_status || !$this->ocm->isCacheAvail('xcoupon')) {
            return false;
        }
        return $this->ocm->getCache('xcoupon');
    }
    public function validate($coupon_id) {
        $status = true;
        $xcoupon_debug = $this->ocm->getConfig('xcoupon_debug', $this->mtype);
        $xcoupon_status = $this->ocm->getConfig('xcoupon_status', $this->mtype);
        $tab_id = $this->getTabIdByCouponId($coupon_id);
        if (!$tab_id || !$xcoupon_status) {
            return true;
        }
        $xcoupons = $this->getCoupons();
        $xmethods = $xcoupons['xmethods'];
        $xmeta = $xcoupons['xmeta'];
        if (empty($xmethods[$tab_id])) {
            return true;
        }
        $xcoupon = $xmethods[$tab_id];
        $address = $this->_replenishAddress();
        $compare_with = $this->_getCommonParams($address);
       
        $xnotice_debug = $this->ocm->getConfig('xnotice_debug', $this->mtype);
        $currency_code = isset($this->session->data['currency']) ? $this->session->data['currency'] : $this->config->get('config_currency');

        if (!empty($this->session->data['default']['shipping_method'])) {
            $shipping_tax_class_id = $this->session->data['default']['shipping_method']['tax_class_id'];
        } else if (!empty($this->session->data['shipping_method'])) {
            $shipping_tax_class_id = $this->session->data['shipping_method']['tax_class_id'];
        } else {
            $shipping_tax_class_id = 0;
        }

        $debugging = array();
        $geo_ids = array();
        if ($xmeta['geo']) {
            $geo_rows = $this->db->query("SELECT geo_zone_id FROM " . DB_PREFIX . "zone_to_geo_zone WHERE country_id = '" . (int)$address['country_id'] . "' AND (zone_id = '" . (int)$address['zone_id'] . "' OR zone_id = '0')")->rows; 
            foreach ($geo_rows as $geo_row) {
                $geo_ids[] = $geo_row['geo_zone_id'];
            }
        }
        $cart_products = $this->cart->getProducts();
        $_cart_data =  $this->getProductProfile($cart_products, $xmeta);
        $_cart_data = $this->fixRounding($_cart_data);

        $_cart_data['xlevel'] = $_cart_data['xdiscount'] = 0;
        if ($xmeta['xdiscount']) {
            $_cart_data['xlevel'] = $this->ocmprice && method_exists($this->ocmprice, 'getCartDiscountValue') ? $this->ocmprice->getCartDiscountValue('xlevel') : 0;
            $_cart_data['xdiscount'] = $this->ocmprice && method_exists($this->ocmprice, 'getCartDiscountValue') ? $this->ocmprice->getCartDiscountValue('xdiscount') : 0; 
        }

        $compare_with['products'] = $_cart_data['products'];
        $compare_with['geo'] = $geo_ids;
        $compare_with['product'] = $_cart_data['product'];
        $compare_with['category'] = $_cart_data['category'];
        $compare_with['manufacturer'] = $_cart_data['manufacturer'];
        $compare_with['option'] = $_cart_data['option'];
        $compare_with['attribute'] = $_cart_data['attribute'];
        $compare_with['location'] = $_cart_data['location'];
        $compare_with['total'] = $_cart_data['total'];
        $compare_with['sub'] = $_cart_data['sub'];
        $compare_with['weight'] = $_cart_data['weight'];
        $compare_with['quantity'] = $_cart_data['quantity'];

        $_cart_data['order_total'] = 0;
        $_cart_data['order_sub'] = 0;
        if ($xmeta['order']) {
            $compare_with['first'] = false;
            if ($this->customer->isLogged()) {
                $order_row = $this->db->query("SELECT total, ot.value FROM `" . DB_PREFIX . "order` o LEFT JOIN `" . DB_PREFIX . "order_total` ot ON o.order_id = ot.order_id WHERE customer_id = '" . (int)$this->customer->isLogged() . "' AND order_status_id != 0 ORDER BY o.order_id DESC LIMIT 1")->row;
                $compare_with['first'] = !$order_row;
                $_cart_data['order_total'] = $order_row['total'];
                $_cart_data['order_sub'] = $order_row['value'];
            }
        }

        $rules = $xcoupon['rules'];
        $rates = $xcoupon['rates'];
        $tab_id = $xcoupon['tab_id'];
        $product_or = $xcoupon['product_or'];
        $debugging_message = array();
        /* adjust multiple values */
        $this->_adjustMultiValues($rules, $_cart_data['products']);
        if (isset($rules['custom']) && $this->customer->isLogged()) {
            $compare_with['custom_field'] = $this->syncAccountFields($compare_with['custom_field']);
        }
        /* if shipping_base is found on shipping_methods list, consider that */
        if (isset($rules['shipping']) && in_array($compare_with['shipping_base'], $rules['shipping']['value'])) {
            $compare_with['shipping_method'] = $compare_with['shipping_base'];
        }
        $alive_or_dead = $this->_crucify($rules, $compare_with, $product_or);
        if (!$alive_or_dead['status']) {
            $status = false;
            $debugging_message = $alive_or_dead['debugging'];
            $debugging[] = array('name' => $xcoupon['display'],'filter' => $debugging_message,'index' => $tab_id);
        } else {
            $applicable_cart = $this->_getApplicableProducts($rules, $_cart_data);
            $need_specified = $xcoupon['have_product_specified'] && $xcoupon['method_specific'];
            $method_specific_data = $this->_getMethodSpecificData($need_specified, $rules, $applicable_cart, $_cart_data, $product_or);
            $discount_total = 0;
            $percent_of = $method_specific_data[$rates['percent_of']];
            $equation = $this->ocm->html_decode($rates['equation']);

            if ($rates['type'] == 'flat') {
                $discount_total = $rates['percent'] ? ($rates['value'] * $percent_of) : $rates['value'];
            } else {
                if ($rates['type'] == 'equation') {
                    $equation_result = $this->getEquationValue($equation, $_cart_data, $method_specific_data, $percent_of);
                    $method_specific_data['equation'] = $equation_result['value'];
                }
                $target_value = $method_specific_data[$rates['type']];
                $_rates = $this->_getTargetFromRange($rates['ranges'], $target_value);
                if (!$_rates) {
                    $debugging_message[] = 'Coupon By - ' . $rates['type'] .' (' . $target_value . ')';
                    $status = false;
                } else {
                    $discount_total = $_rates['percent'] ? ($_rates['value'] * $percent_of) : $_rates['value'];
                }
            }
            // apply equation
            if ($rates['equation']
                    && $xcoupon['have_product_specified']
                    && $rates['equation_specified_param']
                    && !$need_specified) {
                $method_specific_data = $this->_getMethodSpecificData(true, $rules, $applicable_cart, $_cart_data, $product_or);
            }
            if ($rates['equation'] && $rates['type'] != 'equation') {
                $percent_of = $method_specific_data[$rates['percent_of']];
                $equation_result = $this->getEquationValue($equation, $_cart_data, $method_specific_data, $percent_of, $discount_total);
                $discount_total = $equation_result['value'];
                if ((int)$discount_total == -1) {
                    $status = false;
                    $debugging_message[] = 'Final Equation';
                }
            }
            // apply max discount
            if ($rates['max'] && $rates['max'] < $discount_total) {
                $discount_total = $rates['max'];
            }
            if (isset($rates['non_zero']) && $rates['non_zero'] && !$discount_total) {
                $status = false;
                $debugging_message[] = 'Non-Zero coupon';
            }
            // deductable tax
            $tax = array();
            if (!empty($rates['tax_class_id'])) {
                $tax[] = array(
                    'id'    => $rates['tax_class_id'],
                    'value' => $discount_total // without shipping discount 
                );
            }
            // apply free shipping
            if (isset($rates['shipping']) && $rates['shipping'] && $_cart_data['shipping']) {
                $discount_total += $_cart_data['shipping'];
                if ($shipping_tax_class_id) {
                    $tax[] = array(
                        'id'    => $shipping_tax_class_id,
                        'value' => $_cart_data['shipping']
                    );
                }
            }
            /*
            if ($discount_total) {
                $status = false;
                $debugging_message[] = 'Coupon Value is Empty';
            } */
            if ($status) {
                $this->ocm->setCache('xcoupon', array(
                    'discount'  => $discount_total,
                    'tax'       => $tax
                ));
            } else {
                $debugging[] = array('name' => $xcoupon['display'],'filter' => $debugging_message,'index' => $tab_id);
            }
        }
        if ($xcoupon_debug) {
            $this->ocm->writeLog($debugging, 'xcoupon');
        }
        return $status;
    }
    public function getTabIdByCouponId($coupon_id){
        $row = $this->db->query("SELECT tab_id FROM " . DB_PREFIX . "xcoupon_coupons WHERE coupon_id ='" . (int)$coupon_id . "'")->row;
        return $row ? $row['tab_id'] : false;
    }
    public function getTabIdByCouponCode($code){
        $row = $this->db->query("SELECT tab_id FROM " . DB_PREFIX . "xcoupon_coupons WHERE coupon_id IN (SELECT coupon_id FROM `" . DB_PREFIX . "coupon` WHERE code = '" . $this->db->escape($code) . "')")->row;
        return $row ? $row['tab_id'] : false;
    }
    //utility funciton to get a random unused coupon
    public function getRandomCoupon(){
        $row = $this->db->query("SELECT xcc.coupon_id, c.code  FROM " . DB_PREFIX . "xcoupon_coupons xcc INNER JOIN " . DB_PREFIX . "xcoupon xc ON xcc.tab_id = xc.tab_id INNER JOIN " . DB_PREFIX . "coupon c ON c.coupon_id = xcc.coupon_id WHERE c.status = 1 AND c.coupon_id NOT IN (SELECT coupon_id FROM " . DB_PREFIX . "coupon_history) ORDER BY xc.sort_order ASC LIMIT 1")->row;
        return $row;
    }
    private function getCoupons() {
        $xcoupon = $this->cache->get('ocm.xcoupon');
        if (!$xcoupon) {
            $xmethods = array();
            $xmeta = array(
                'geo'             => false,
                'category_query'  => false,
                'product_query'   => false,
                'attribute_query' => false,
                'order'           => false,
                'xdiscount'       => false
            );
            $xcoupon_rows = $this->db->query("SELECT * FROM `" . DB_PREFIX . "xcoupon` order by `sort_order` asc")->rows;
            foreach($xcoupon_rows as $xcoupon_row) {
                $method_data = $xcoupon_row['method_data'];
                $method_data = json_decode($method_data, true);
                if ($method_data && is_array($method_data) && $method_data['status']) {
                    $method_data =  $this->_resetEmptyRule($method_data);
                    $rules = $this->_findValidRules($method_data);
                    $rates = $this->_findRawRate($method_data);

                    $have_product_specified = false;
                    if ($method_data['category'] > 1
                        || $method_data['product'] > 1
                        || $method_data['manufacturer_rule'] > 1
                        || $method_data['option'] > 1
                        || $method_data['attribute'] > 1
                        || $method_data['location_rule'] > 1) {
                        $have_product_specified = true;
                    }
                    $xmethods[$xcoupon_row['tab_id']] = array(
                        'tab_id'                 => (int)$xcoupon_row['tab_id'],
                        'display'                => $method_data['display'],
                        'rules'                  => $rules,
                        'rates'                  => $rates,
                        'product_or'             => $method_data['product_or'],
                        'method_specific'        => !!$method_data['method_specific'],
                        'have_product_specified' => $have_product_specified
                    );
                    if ($method_data['geo_zone_all'] != 1) {
                        $xmeta['geo'] = true;
                    }
                    if ($method_data['category'] > 1) {
                        $xmeta['category_query'] = true;
                    }
                    if ($method_data['manufacturer_rule'] > 1
                        || $method_data['location_rule'] > 1) {
                        $xmeta['product_query'] = true;
                    }
                    if ($method_data['attribute'] > 1) {
                        $xmeta['attribute_query'] = true; 
                    }
                    if (!!$method_data['first']
                        || strpos($method_data['equation'], '{lastOrderTotal}') !== false
                        || strpos($method_data['equation'], '{lastOrderSub}') !== false) {
                        $xmeta['order'] = true;
                    }
                    if (stripos($method_data['equation'], '{xlevel}') !== false
                        || stripos($method_data['equation'], '{xdiscount}') !== false) {
                        $xmeta['xdiscount'] = true;
                    }
                }
            }
            $xcoupon = array('xmeta' => $xmeta, 'xmethods' => $xmethods);
            $this->cache->set('ocm.xcoupon', $xcoupon);
        }
        return $xcoupon;
    }
    private function getEquationValue($equation, $_cart_data, $method_specific_data, $percent_of, $coupon_value = 0) {
        $placholder = array(
            '{subTotal}',
            '{subTotalWithTax}',
            '{special}',
            '{quantity}',
            '{weight}',
            '{noOfProduct}', 
            '{noOfCategory}', 
            '{noOfManufacturer}', 
            '{noOfLocation}',
            '{subTotalAsPerProductRule}',
            '{subTotalWithTaxAsPerProductRule}',
            '{quantityAsPerProductRule}',
            '{weightAsPerProductRule}',
            '{reward}',
            '{voucher}',
            '{shipping}',
            '{shippingWithTax}',
            '{xcoupon}',
            '{highest}',
            '{lowest}',
            '{highestQnty}',
            '{lowestQnty}',
            '{lastOrderTotal}',
            '{lastOrderSub}',
            '{nonMethodSub}',
            '{nonMethodQnty}',
            '{xlevel}',
            '{xdiscount}'
        );
        $replacer = array(
            $_cart_data['sub'],
            $_cart_data['total'],
            $_cart_data['special'],
            $_cart_data['quantity'],
            $_cart_data['weight'],
            $_cart_data['no_product'],
            $_cart_data['no_category'],
            $_cart_data['no_manufacturer'],
            $_cart_data['no_location'],
            $method_specific_data['sub'],
            $method_specific_data['total'],
            $method_specific_data['quantity'],
            $method_specific_data['weight'],
            $_cart_data['reward'],
            $_cart_data['vouchers'],
            $_cart_data['shipping'],
            $_cart_data['shipping_plus'],
            $coupon_value,
            $method_specific_data['highest'],
            $method_specific_data['lowest'],
            $method_specific_data['highest_qnty'],
            $method_specific_data['lowest_qnty'],
            $_cart_data['order_total'],
            $_cart_data['order_sub'],
            $method_specific_data['non_method_sub'],
            $method_specific_data['non_method_quantity'],
            $_cart_data['xlevel'],
            $_cart_data['xdiscount']
        );
        /* xfeepro value */
        $xfeepro = $this->ocm->getCache('xfeepro');
        if ($xfeepro && is_array($xfeepro)) {
            foreach ($xfeepro as $single) {
                $placholder[] = '{'.$single['code'].'}';
                $replacer[] = $single['cost'];
            }
        }
        $equation = str_replace($placholder, $replacer, $equation);
        /* replace percentage value finally so it won't replace mod operator */
        $equation = preg_replace('/(\d+)%/', '$1*' . ($percent_of/100), $equation);
        /* Removing unwanted placeholder */
        if (strpos($equation, '{') !== false) {
            $equation = preg_replace('/{.*?}/', 0, $equation);
        }
        $condition_status = false;
        $value = (float)$this->calculate_string($equation, $condition_status);
        return array(
            'value'    => $value,
            'status'  => $condition_status 
        );
    }
    private function _resetEmptyRule($data) {
        $rules = array(
            'store'             => 'store_all',
            'customer_group'    => 'customer_group_all',
            'geo_zone'          => 'geo_zone_all',
            'country'           => 'country_all',
            'zone'              => 'zone_all',
            'payment'           => 'payment_all',
            'shipping'          => 'shipping_all',
            'customers'         => 'customer_all',
            'days'              => 'days_all',
            'product_category'  => 'category',
            'product_product'   => 'product',
            'product_option'    => 'option',
            'manufacturer'      => 'manufacturer_rule',
            'location'          => 'location_rule',
            'product_attribute' => 'attribute',
            'custom'            => 'custom_all'
        );
        foreach ($rules as $key => $value) {
            if (!isset($data[$value])) {
                $data[$value] = '';
            }
            if (!isset($data[$key]) || !$data[$key]) {
                $data[$value] = 1;
            }
            /* make empty product entry if all is selected */
            if ($data[$value] < 2 && in_array($key, array('product_category', 'product_product', 'product_option', 'product_attribute', 'manufacturer', 'location'))) {
                $data[$key] = array();
            }
        }
        /* reset cost params  */ 
        if (!isset($data['ranges'])) $data['ranges'] = array();
        /* checkboxes */
        if (!isset($data['product_or'])) $data['product_or'] = 1;
        if (!isset($data['method_specific'])) $data['method_specific'] = '';
        if (!isset($data['freeship'])) $data['freeship'] = '';
        if (!isset($data['non_zero'])) $data['non_zero'] = '';
        if (!isset($data['first'])) $data['first'] = '';
        /* Reset other */
        if (!isset($data['days'])) $data['days'] = array();
        if (empty($data['display'])) $data['display'] = 'Untitled Item';
        if (empty($data['total_end'])) $data['total_end'] = PHP_INT_MAX;
        if (empty($data['weight_end'])) $data['weight_end'] = PHP_INT_MAX;
        if (empty($data['quantity_end'])) $data['quantity_end'] = PHP_INT_MAX;
        return $data;
    }
    private function _findRawRate($data) {
        $rates = array();
        $rates['type'] = $data['rate_type'];
        $rates['equation'] = $data['equation'];
        $rates['equation_specified_param'] = (strpos($data['equation'], 'PerProductRule') !== false);
        $rates['percent_of'] = $data['rate_percent'];
        $rates['tax_class_id'] = !empty($data['tax_class_id']) ? $data['tax_class_id'] : 0;
        $rates['shipping'] = !empty($data['freeship']);
        $rates['non_zero'] = !empty($data['non_zero']);
        
        if ($data['rate_type'] == 'flat') {
            $cost = trim(trim($data['cost']), '-');
            if (substr($cost, -1) == '%') {
                $cost = rtrim($cost,'%');
                $rates['percent'] = true;
                $rates['value'] = (float)$cost / 100;
            } else {
                $rates['percent'] = false;
                $rates['value'] = (float)$cost;
            }
        } else {
            $ranges = array();
            foreach($data['ranges'] as $range) {
                $start = (float)$range['start'];
                $end = (float)$range['end'];
                $cost = trim(trim($range['cost']), '-');
                if (substr($cost, -1) == '%') {
                    $cost = rtrim($cost,'%');
                    $percent = true;
                    $value = (float)$cost / 100;
                } else {
                    $percent = false;
                    $value = (float)$cost;
                }
                if ($start && !$end) {
                    $end = PHP_INT_MAX;
                }
                $ranges[] = array('start' => $start, 'end' => $end, 'percent' => $percent, 'value' => $value);
            }
            $rates['ranges'] = $ranges;
        }
        $rates['max'] = (float)$data['max'];
        return $rates;
    }
    private function _getTargetFromRange($ranges, $target) {
        $target_range = array();
        foreach($ranges as $range) {
            if ($range['start'] <= $target && $target <= $range['end']) {
                $target_range = $range;
                break;
            }
        }
        return $target_range;
    }
    private function _findValidRules($data) {
        $rules = array();
        if ($data['store_all'] != 1) {
            $rules['store'] = array(
                'type' => 'in_array',
                'product_rule' => false,
                'address_rule' => false,
                'value' => $data['store'],
                'compare_with' => 'store_id',
                'false_value' => false
            );
        }
        if ($data['customer_group_all'] != 1) {
            $rules['customer_group'] = array(
                'type' => 'in_array',
                'product_rule' => false,
                'address_rule' => false,
                'value' => $data['customer_group'],
                'compare_with' => 'customer_group_id',
                'false_value' => false
            );
        }
        if ($data['geo_zone_all'] != 1) {
            $rules['geo_zone'] = array(
                'type' => 'intersect',
                'product_rule' => false,
                'address_rule' => true,
                'value' => $data['geo_zone'],
                'compare_with' => 'geo',
                'false_value' => false
            );
        }
        if ($data['country_all'] != 1) {
            $rules['country'] = array(
                'type' => 'in_array',
                'product_rule' => false,
                'address_rule' => true,
                'value' => $data['country'],
                'compare_with' => 'country_id',
                'false_value' => false
            );
        }
        if ($data['zone_all'] != 1) {
            $rules['zone'] = array(
                'type' => 'in_array',
                'product_rule' => false,
                'address_rule' => true,
                'value' => $data['zone'],
                'compare_with' => 'zone_id',
                'false_value' => false
            );
        }
        if ($data['payment_all'] != 1) {
            $rules['payment'] = array(
                'type' => 'in_array',
                'product_rule' => false,
                'address_rule' => false,
                'value' => $data['payment'],
                'compare_with' => 'payment_method',
                'false_value' => false
            );
        }
        if ($data['shipping_all'] != 1) {
            $rules['shipping'] = array(
                'type' => 'in_array',
                'product_rule' => false,
                'address_rule' => false,
                'value' => $data['shipping'],
                'compare_with' => 'shipping_method',
                'false_value' => false
            );
        }
        if ($data['customer_all'] != 1) {
            $false_value = ($data['customer_rule'] == 'inclusive') ? false : true;
            $rules['customers'] = array(
                'type' => 'in_array',
                'product_rule' => false,
                'address_rule' => false,
                'value' => $data['customers'],
                'compare_with' => 'customer_id',
                'false_value' => $false_value
            );
        }
        if ($data['custom_all'] != 1) {
            $rules['custom'] = array(
                'type' => 'intersect',
                'product_rule' => false,
                'address_rule' => false,
                'value' => $data['custom'],
                'compare_with' => 'custom_field',
                'false_value' => false
            );
        }
        if ((int)$data['product'] > 1) {
            $rules['product'] = array(
                'type' => 'function',
                'func' => '_validateProduct',
                'product_rule' => true,
                'address_rule' => false,
                'value' => $data['product_product'],
                'compare_with' => 'product',
                'rule_type' => $data['product'],
                'false_value' => false
            );
        }
        if ((int)$data['category'] > 1) {
            $rules['category'] = array(
                'type' => 'function',
                'func' => '_validateProduct',
                'product_rule' => true,
                'address_rule' => false,
                'value' => $data['product_category'],
                'compare_with' => 'category',
                'rule_type' => $data['category'],
                'false_value' => false
            );
        }
        if ((int)$data['manufacturer_rule'] > 1) {
            $rules['manufacturer'] = array(
                'type' => 'function',
                'func' => '_validateProduct',
                'product_rule' => true,
                'address_rule' => false,
                'value' => $data['manufacturer'],
                'compare_with' => 'manufacturer',
                'rule_type' => $data['manufacturer_rule'],
                'false_value' => false
            );
        }
        if ((int)$data['option'] > 1) {
            $rules['option'] = array(
                'type' => 'function',
                'func' => '_validateProduct',
                'product_rule' => true,
                'address_rule' => false,
                'value' => $data['product_option'],
                'compare_with' => 'option',
                'rule_type' => $data['option'],
                'false_value' => false
            );
        }
        if ((int)$data['attribute'] > 1) {
            $rules['attribute'] = array(
                'type' => 'function',
                'func' => '_validateProduct',
                'product_rule' => true,
                'address_rule' => false,
                'value' => $data['product_attribute'],
                'compare_with' => 'attribute',
                'rule_type' => $data['attribute'],
                'false_value' => false
            );
        }
        if ((int)$data['location_rule'] > 1) {
            $location = array_map('strtolower', $data['location']);
            $location = array_map('trim', $location);
            $rules['location'] = array(
                'type' => 'function',
                'func' => '_validateProduct',
                'product_rule' => true,
                'address_rule' => false,
                'value' => $location,
                'compare_with' => 'location',
                'rule_type' => $data['location_rule'],
                'false_value' => false
            );
        }
        if ($data['first']) {
            $rules['first'] = array(
                'type' => 'equal',
                'product_rule' => false,
                'address_rule' => false,
                'value' => '',
                'compare_with' => 'first',
                'false_value' => false
            );
        }
        if ($data['days_all'] != 1 && is_array($data['days']) && $data['days'] && count($data['days']) !== 7) {
            $rules['days'] = array(
                'type' => 'in_array',
                'product_rule' => false,
                'address_rule' => false,
                'value' => $data['days'],
                'compare_with' => 'day',
                'false_value' => false
            );
        }
        if ($data['date_start'] != "" && $data['date_end']) {
            $rules['date'] = array(
                'type' => 'in_between',
                'product_rule' => false,
                'address_rule' => false,
                'start' => $data['date_start'],
                'end' => $data['date_end'],
                'compare_with' => 'date'
            );
        }
        if ($data['time_start'] != "" && $data['time_end'] != "") {
            $valid_hours = array();
            $time_start = (int)$data['time_start'];
            $time_end = (int)$data['time_end'];

            if ($time_start <= $time_end) {
               for ($i = $time_start; $i < $time_end ; $i++) { 
                  $valid_hours[] = $i;
               }
            } else {
               for ($i = 0; $i < $time_end ; $i++) { 
                  $valid_hours[] = $i;
               }
               for ($i = $time_start; $i <= 23 ; $i++) { 
                  $valid_hours[] = $i;
               }
            }
            if ($valid_hours) {
                $rules['time'] = array(
                    'type' => 'in_array',
                    'product_rule' => false,
                    'address_rule' => false,
                    'value' => $valid_hours,
                    'compare_with' => 'time',
                    'false_value' => false
                );
            }
        }
        /* Special rule if only ending time and date range set */
        if ($data['date_start'] != "" && $data['date_end'] && !$data['time_start'] && $data['time_end']) {
            $valid_hours = array();
            $time_start = 0;
            $time_end = (int)$data['time_end'];
            for ($i = $time_start; $i < $time_end ; $i++) { 
                  $valid_hours[] = $i;
            }
            $rules['date_time'] = array(
                'type' => 'in_array_not_equal',
                'product_rule' => false,
                'value' => $valid_hours,
                'compare_with' => 'time',
                'not_equal_value' => $data['date_end'],
                'not_equal_with' => 'date',
                'false_value' => false
            );
        }
        if ($data['rate_type'] != 'sub'
            && $data['rate_type'] != 'total'
            && $data['rate_type'] != 'sub_special'
            && $data['total_start'] != ""
            && (float)$data['total_end']) {
            $rules['additional_total'] = array(
                'type' => 'in_between',
                'product_rule' => false,
                'address_rule' => false,
                'start' => (float)$data['total_start'],
                'end' => (float)$data['total_end'],
                'compare_with' => 'total'
            );
        }
        if ($data['rate_type'] != 'weight'
            && $data['weight_start'] != ""
            && (float)$data['weight_end']) {
            $rules['additional_weight'] = array(
                'type' => 'in_between',
                'product_rule' => false,
                'address_rule' => false,
                'start' => (float)$data['weight_start'],
                'end' => (float)$data['weight_end'],
                'compare_with' => 'weight'
            );
        }
        if ($data['rate_type'] != 'quantity'
            && $data['quantity_start'] != ""
            && (int)$data['quantity_end']) {
            $rules['additional_quantity'] = array(
                'type' => 'in_between',
                'product_rule' => false,
                'address_rule' => false,
                'start' => (int)$data['quantity_start'],
                'end' => (int)$data['quantity_end'],
                'compare_with' => 'quantity'
            );
        }
        return $rules;
    }
    private function syncAccountFields($custom_field) {
        $this->load->model('account/customer');
        $customer_info = $this->model_account_customer->getCustomer($this->customer->getId());
        $acc_custom_field = VERSION >= '2.1.0.0' ? json_decode($customer_info['custom_field'], true) : unserialize($customer_info['custom_field']);
        if (is_array($acc_custom_field)) {
            foreach ($acc_custom_field as $_custom_field) {
                if (is_array($_custom_field)) {
                    $custom_field = array_merge($custom_field, $_custom_field);
                } else {
                    $custom_field[] = $_custom_field;
                }
            }
        }
        return $custom_field;
    }
    /* HOOK METHOD HERE */
    /* must start with hook_
    public function hook_custom_field($value, $cart_products, $name) {
        return true;
    } */
}