<?php
class ControllerExtensionModuleXCoupon extends Controller {
    public function validate($route, $input, &$output) {
        if ($output && !empty($output['coupon_id'])) {
            $this->load->model('extension/module/xcoupon');
            $status = $this->model_extension_module_xcoupon->validate($output['coupon_id']);
            if (!$status) {
                $output = false;
            }
        }
    }
    public function getTotal($route, &$input) {
        if (isset($this->session->data['coupon'])) {
            $this->load->model('extension/total/coupon');
            $this->load->model('extension/module/xcoupon');
            if ($this->model_extension_module_xcoupon->getTabIdByCouponCode($this->session->data['coupon'])) {
                $coupon_info = $this->model_extension_total_coupon->getCoupon($this->session->data['coupon']);
                $total = VERSION >= '2.3.0.0' ? $input[0] : $input;
                $xcoupon = $this->model_extension_module_xcoupon->getTotal();
                if ($coupon_info && $xcoupon !== false) {
                    $discount_total = $xcoupon['discount'];
                    if (VERSION >= '3.0.0.2') {
                        $this->load->language('extension/total/coupon', 'coupon');
                        $title = $this->language->get('coupon')->get('text_coupon');
                    } else if (VERSION >= '2.3.0.0') {
                        $this->load->language('extension/total/coupon');
                        $title = $this->language->get('text_coupon');
                    } else {
                        $this->load->language('total/coupon');
                        $title = $this->language->get('text_coupon');
                    }
                    $sort_order = (VERSION >= '3.0.0.0') ? $this->config->get('total_coupon_sort_order') : $this->config->get('coupon_sort_order');
                    $total['totals'][] = array(
                        'code'       => 'coupon',
                        'title'      => sprintf($title, $this->session->data['coupon']),
                        'value'      => -$discount_total,
                        'sort_order' => $sort_order
                    );
                    $total['total'] -= $discount_total;
                    // deduct tax if it is available 
                    if ($xcoupon['tax'] && $total['taxes']) {
                        foreach ($xcoupon['tax'] as $tax) {
                            $tax_rates = $this->tax->getRates($tax['value'], $tax['id']);
                            foreach ($tax_rates as $tax_rate) {
                                if ($tax_rate['type'] == 'P') {
                                    $total['taxes'][$tax_rate['tax_rate_id']] -= $tax_rate['amount'];
                                }
                            }
                        }
                    }
                    return true;
                }
            }
        }
    }
 }