<?php
class ModelExtensionModuleXcoupon extends Model {
    use OCM\Traits\Back\Model\Crud;
    use OCM\Traits\Back\Model\Product;
    private $name = 'xcoupon';
    public function addDBTables() {
        $sql = "
            CREATE TABLE IF NOT EXISTS `".DB_PREFIX."xcoupon` (
              `id` int(8) NOT NULL AUTO_INCREMENT,
              `method_data` MEDIUMTEXT NULL,
              `tab_id` int(8) NULL,
              `sort_order` int(8) NULL,
               PRIMARY KEY (`id`)
            ) ENGINE=MyISAM  DEFAULT CHARSET=utf8;
        ";
        $query = $this->db->query($sql);
        $sql2 = "
            CREATE TABLE IF NOT EXISTS `".DB_PREFIX."xcoupon_coupons` (
              `tab_id` int(11) NULL,
              `coupon_id` int(11) NULL
            ) ENGINE=MyISAM  DEFAULT CHARSET=utf8;
        ";
        $query = $this->db->query($sql2);
    }
    /* Start of coupon manager */
    public function addCoupon($data) {
        $default = array(
            'discount'      => 0,
            'type'          => 'F',
            'logged'        => 0,
            'shipping'      => 0,
            'total'         => 0,
            'date_start'    => date('Y-m-d', time()),
            'date_end'      => date('Y-m-d', strtotime('+5 year')),
            'uses_total'    => 1,
            'uses_customer' => 1,
            'status'        => 1
        );
        $data = array_merge($default, $data);
        $this->db->query("INSERT INTO " . DB_PREFIX . "coupon SET name = '" . $this->db->escape($data['name']) . "', code = '" . $this->db->escape($data['code']) . "', discount = '" . (float)$data['discount'] . "', type = '" . $this->db->escape($data['type']) . "', total = '" . (float)$data['total'] . "', logged = '" . (int)$data['logged'] . "', shipping = '" . (int)$data['shipping'] . "', date_start = '" . $this->db->escape($data['date_start']) . "', date_end = '" . $this->db->escape($data['date_end']) . "', uses_total = '" . (int)$data['uses_total'] . "', uses_customer = '" . (int)$data['uses_customer'] . "', status = '" . (int)$data['status'] . "', date_added = NOW()");
        $coupon_id = $this->db->getLastId();
        return array(
            'coupon_id' => $coupon_id,
            'name'      => $data['name'],
            'code'      => $data['code']
        );
    }
    public function addXCoupon($coupons_id, $tab_id){
         $this->db->query("INSERT INTO " . DB_PREFIX . "xcoupon_coupons SET coupon_id = ". (int)$coupons_id .", tab_id = " . (int)$tab_id);
    }
    public function addBatchCoupons($data) {
        $return = array();
        for($i = 1; $i <= $data['total']; $i++) {
            $code = $this->generateCoupon($data);
            if ($code) {
                $_coupon = array();
                $_coupon['name'] = $data['name'];
                $_coupon['code'] = $code;
                $result = $this->addCoupon($_coupon);
                $this->addXCoupon($result['coupon_id'], $data['tab_id']);
                $return[] = $result;
            }
        }
        return $return;
    }
    private function generateCoupon($data) {
        $code = "";
        $chars = array('A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'U', 'V', 'W', 'X', 'Y', 'Z');
        for($i = 1; $i <= 50; $i++) {
            $code = $chars[array_rand($chars)] . $chars[array_rand($chars)] . $chars[array_rand($chars)] . rand(100, 32000) . rand(20, 32000) . rand(20, 32000);
            $code = substr($data['prefix'] . $code, 0, $data['length']);
            if (!$this->couponExist($code)) {
                break;
            }
            $count++;
        }
        return $code;
    }
    public  function getTotalUsed($data) {
        $sql = "SELECT count(ch.coupon_id) AS total FROM " . DB_PREFIX . "xcoupon_coupons AS xc INNER JOIN " . DB_PREFIX ."coupon_history AS ch ON ch.coupon_id = xc.coupon_id";
        if (!empty($data['tab_id'])) {
            $sql .= " WHERE xc.tab_id = '" . (int)$data['tab_id'] . "'";
        }
        if (!empty($data['filter'])) {
            $sql .= " AND (ch.code LIKE '%" . $this->db->escape($data['filter']) . "%' OR ch.name LIKE '%" . $this->db->escape($data['filter']) . "%')";
        }
        return $this->db->query($sql)->row['total'];
    }
    public  function getTotalCoupons($data) {
        $sql = "SELECT count(c.coupon_id) AS total FROM " . DB_PREFIX . "xcoupon_coupons AS xc INNER JOIN " . DB_PREFIX ."coupon AS c ON c.coupon_id = xc.coupon_id";
        if (!empty($data['tab_id'])) {
            $sql .= " WHERE xc.tab_id = '" . (int)$data['tab_id'] . "'";
        }
        if (!empty($data['filter'])) {
            $sql .= " AND (c.code LIKE '%" . $this->db->escape($data['filter']) . "%' OR c.name LIKE '%" . $this->db->escape($data['filter']) . "%')";
        }
        return $this->db->query($sql)->row['total'];
    }
    public function getCoupons($data) {
        $sql = "SELECT c.coupon_id, c.name, c.code, c.discount, c.type FROM " . DB_PREFIX . "xcoupon_coupons AS xc INNER JOIN " . DB_PREFIX ."coupon AS c ON c.coupon_id = xc.coupon_id";
        if (!empty($data['tab_id'])) {
            $sql .= " WHERE xc.tab_id = '" . (int)$data['tab_id'] . "'";
        }
        if (!empty($data['filter'])) {
            $sql .= " AND (c.code LIKE '%" . $this->db->escape($data['filter']) . "%' OR c.name LIKE '%" . $this->db->escape($data['filter']) . "%')";
        }
        $sql .= " ORDER BY `code` ASC";
        if (isset($data['start']) || isset($data['limit'])) {
            if ($data['start'] < 0) {
                $data['start'] = 0;
            }
            if ($data['limit'] < 1) {
                $data['limit'] = 10;
            }
            $sql .= " LIMIT " . (int)$data['start'] . "," . (int)$data['limit'];
        }
        return $this->db->query($sql)->rows;
    }
    public function getUnlinkedCoupons($data) {
        $sql = "SELECT c.coupon_id, c.name, c.code, c.discount, c.type FROM " . DB_PREFIX ."coupon c WHERE status = 1 AND NOT EXISTS(SELECT coupon_id FROM " . DB_PREFIX ."xcoupon_coupons WHERE coupon_id = c.coupon_id)";
        if (!empty($data['filter'])) {
            $sql .= " AND (c.code LIKE '%" . $this->db->escape($data['filter']) . "%' OR c.name LIKE '%" . $this->db->escape($data['filter']) . "%')";
        }
        $sql .= " ORDER BY `code` ASC";
        if (isset($data['start']) || isset($data['limit'])) {
            if ($data['start'] < 0) {
                $data['start'] = 0;
            }
            if ($data['limit'] < 1) {
                $data['limit'] = 10;
            }
            $sql .= " LIMIT " . (int)$data['start'] . "," . (int)$data['limit'];
        }
        return $this->db->query($sql)->rows;
    }
    public function linkedCoupons($tab_id, $data) {
        if ($data && is_array($data)) {
            foreach ($data as $coupon_id) {
                $this->addXCoupon($coupon_id, $tab_id);
            }
        }
    }
    public function updateCouponsByTabId($tab_id, $data) {
        $this->db->query("UPDATE ". DB_PREFIX . "coupon SET name = '" . $this->db->escape($data['name']) . "', uses_total = '" . (int)$data['uses_total'] . "', uses_customer = '" . (int)$data['uses_customer'] . "', status = '" . (int)$data['status'] . "' WHERE coupon_id IN (SELECT coupon_id FROM ". DB_PREFIX . "xcoupon_coupons WHERE tab_id = '" . (int)$tab_id . "')");
    }
    public function deleteCoupon($coupon_id, $both = true){
        $this->db->query("DELETE FROM ". DB_PREFIX . "xcoupon_coupons WHERE coupon_id = '" . (int)$coupon_id . "'");
        if ($both) {
            $this->db->query("DELETE FROM ". DB_PREFIX . "coupon WHERE coupon_id = '" . (int)$coupon_id . "'");
        }
    }
    public function deleteCouponByTabId($tab_id) {
        $this->db->query("DELETE FROM ". DB_PREFIX . "coupon WHERE coupon_id IN (SELECT coupon_id FROM ". DB_PREFIX . "xcoupon_coupons WHERE tab_id = '" . (int)$tab_id . "')");
        $this->db->query("DELETE FROM ". DB_PREFIX . "xcoupon_coupons WHERE tab_id = '" . (int)$tab_id . "'");
    }
    public function couponExist($code) {
        return !!$this->db->query("SELECT coupon_id FROM `" . DB_PREFIX . "coupon` WHERE code = '" . $this->db->escape($code) . "'")->row;
    }
    /* end of coupon manager */
}