<?php
class ControllerExtensionModuleXcoupon extends Controller {
     use OCM\Traits\Back\Controller\Common;
     use OCM\Traits\Back\Controller\Crud;
     use OCM\Traits\Back\Controller\Product;
     use OCM\Traits\Back\Controller\Util;
     private $ext_path;
     private $ext_key;
     private $error = array();
     private $ocm;
     private $meta = array(
        'id'       => '39220',
        'type'     => 'module',
        'name'     => 'xcoupon',
        'path'     => 'extension/module/',
        'title'    => 'X-Coupon',
        'version'  => '1.0.8',
        'ocmod'    => true
    );
    /* Config with default values  Special keyword __LANG__ denotes array of languages e.g 'name' => array('__LANG__' => 'xyz') */
    private $setting = array(
        'xcoupon_status'   => '',
        'xcoupon_debug'    => '' 
    );
    private $events = array(
        array(
            'trigger' => 'admin/view/common/column_left/before',
            'action'  => 'extension/module/xcoupon/onColumnLeft'
        ),
        array(
            'trigger' => 'catalog/model/extension/total/coupon/getCoupon/after',
            'action'  => 'extension/module/xcoupon/validate'
        ),
        array(
            'trigger' => 'catalog/model/extension/total/coupon/getTotal/before',
            'action'  => 'extension/module/xcoupon/getTotal'
        )
    );
    private $tables = array(
        'xcoupon'         => array (),
        'xcoupon_coupons' => array ()
    );
    public function __construct($registry) {
        parent::__construct($registry);
        $this->ocm = new OCM\Back($registry, $this->meta);
        $this->ext_path = $this->meta['path'] . $this->meta['name'];
        $this->ext_key = 'model_' . str_replace('/', '_', $this->ext_path);
    }
    
    public function index() {
        $this->load->language($this->ext_path);
        $ext_lang = $this->load->language($this->ext_path);
        $this->load->model($this->ext_path);
        $this->document->setTitle($this->language->get('heading_title'));
        $this->load->model('setting/setting');

        /* Some help lang modificaiton */
        $ext_lang['help_time'] = sprintf($this->language->get('help_time'), date('h:i:s A'));
        $ext_lang['help_date'] = sprintf($this->language->get('help_date'), date('Y-m-d'));

        $data = array();
        $data = array_merge($data, $ext_lang);

        /* লাইসেন্স বেরিফিকেসন  */
        $rs = $this->ocm->rpd();
        $data['_v'] = $rs ? '' : $this->ocm->vs();
        /* লাইসেন্স শেষ */
        $this->ocm->checkOCMOD();
        $this->upgrade();

        if (($this->request->server['REQUEST_METHOD'] == 'POST') && $this->validate()) {
            if(isset($this->request->post['action']) && $this->request->post['action'] == 'import') {
                $this->import();
                $this->response->redirect($this->ocm->url->getExtensionURL());
            }
            $this->session->data['success'] = $this->language->get('text_success');
            $this->response->redirect($this->ocm->url->getExtensionsURL());
        }

        $data['heading_title'] = $this->language->get('heading_title');
        $data['x_name'] = $this->meta['name'];
        $data['x_path'] = $this->meta['path'] . $this->meta['name'];

       if (isset($this->error['warning'])) {
            $data['error_warning'] = $this->error['warning'];
        } else {
            $data['error_warning'] = '';
        }
        if (isset($this->session->data['warning'])) {
            $data['error_warning'] = $this->session->data['warning'];
            unset($this->session->data['warning']);
        }
        if (isset($this->session->data['success'])) {
            $data['success'] = $this->session->data['success'];
            unset($this->session->data['success']);
        } else {
            $data['success'] = '';
        }
        $data['breadcrumbs'] = array();
        $data['breadcrumbs'][] = array(
            'text' => $this->language->get('text_home'),
            'href' => $this->ocm->url->link('common/dashboard', '', true)
        );
        $data['breadcrumbs'][] = array(
            'text' => $this->language->get('text_extension'),
            'href' => $this->ocm->url->getExtensionsURL()
        );
        $data['breadcrumbs'][] = array(
            'text' => $this->language->get('heading_title'),
            'href' => $this->ocm->url->getExtensionURL()
        );

        $data['action'] = $this->ocm->url->getExtensionURL();
        $data['cancel'] = $this->ocm->url->getExtensionsURL();
        
        $this->load->model('localisation/language');
        $languages = $this->model_localisation_language->getLanguages();
        $data['languages'] = $this->ocm->url->getLangImage($languages);
        $data['language_id'] = $this->config->get('config_language_id');

        $data['method_data'] = $this->{$this->ext_key}->getData();
        /* All required options */
        $options = $this->getFormBuilderOptions($data);
        /* set form data */
        $this->ocm->form->setLangs($ext_lang)->setOptions($options);

        $placeholders = array(
            '{subTotal}' => $this->language->get('text_eq_cart_total'),
            '{subTotalWithTax}' => $this->language->get('text_eq_cart_total_tax'),
            '{weight}' => $this->language->get('text_eq_cart_weight'),
            '{quantity}' => $this->language->get('text_eq_cart_qnty'),
            '{subTotalAsPerProductRule}' => $this->language->get('text_eq_method_total'),
            '{subTotalWithTaxAsPerProductRule}' => $this->language->get('text_eq_method_total_tax'),
            '{weightAsPerProductRule}' => $this->language->get('text_eq_method_weight'),
            '{quantityAsPerProductRule}' => $this->language->get('text_eq_method_qnty'),
            '{shipping}' => $this->language->get('text_eq_shipping'),
            '{shippingWithTax}' => $this->language->get('text_eq_shipping_tax'),
            '{voucher}' => $this->language->get('text_eq_vouchers'),
            '{reward}' => $this->language->get('text_eq_reward'),
            '{special}'  => $this->language->get('text_eq_special'),
            '{xcoupon}' => $this->language->get('text_eq_coupon'),
            '{noOfProduct}' => $this->language->get('text_eq_no_product'),
            '{noOfCategory}' => $this->language->get('text_eq_no_cat'),
            '{noOfLocation}' => $this->language->get('text_eq_no_loc'),
            '{noOfManufacturer}' => $this->language->get('text_eq_no_man'),
            '{highest}'          => $this->language->get('text_eq_highest'),
            '{lowest}'           => $this->language->get('text_eq_lowest'),
            '{highestQnty}'      => $this->language->get('text_eq_highest_qnty'),
            '{lowestQnty}'       => $this->language->get('text_eq_lowest_qnty'),
            '{lastOrderTotal}'   => $this->language->get('text_eq_last_order_total'),
            '{lastOrderSub}'     => $this->language->get('text_eq_last_order_sub'),
            '{nonMethodSub}'     => $this->language->get('text_eq_non_method_sub'),
            '{nonMethodQnty}'    => $this->language->get('text_eq_non_method_qnty'),
            '{xlevel}'           => $this->language->get('text_xlevel_discount'),
            '{xdiscount}'        => $this->language->get('text_xdiscount_discount')
        );

        $more_help = array();
        $eq_placeholders = $this->getPlaceholderList($placeholders);
        $more_help['equation'] = $this->ocm->misc->getHelpTag($data['more_equation']) . $eq_placeholders;
        $more_help['zone'] = $data['more_zone'];
        $data['more_help'] = json_encode($more_help);
        
        $data['oc_3_1'] = VERSION >= '3.1.0.0';
        $data['global'] = $this->getConfigForm($data);
        $data['tpl'] = json_encode(array(
            'method'     =>  $this->getFormData($data, true)
        ));
        $data['methods'] = $this->getMethodList($data['method_data']);
        $data['form_data'] = $this->getFormData($data);

        $data['header'] = $this->load->controller('common/header');
        $data['column_left'] = $this->load->controller('common/column_left');
        $data['footer'] = $this->load->controller('common/footer');
        $this->response->setOutput($this->ocm->view($this->ext_path, $data));
    }
    private function getFormBuilderOptions($data) {
        $options = array();
        $this->load->model('localisation/tax_class'); 
        $tax_classes = $this->model_localisation_tax_class->getTaxClasses();
        array_unshift($tax_classes, array('tax_class_id' => 0,'name' => $this->language->get('text_none')));
        $options['tax_class_id'] = $this->ocm->form->getOptions($tax_classes, 'tax_class_id');

        $this->load->model('localisation/geo_zone');
        $geo_zones = $this->model_localisation_geo_zone->getGeoZones();
        $options['geo_zone'] = $this->ocm->form->getOptions($geo_zones, 'geo_zone_id');

        $this->load->model('setting/store');
        $stores = $this->model_setting_store->getStores();
        array_unshift($stores, array('store_id' => 0,'name' => $this->language->get('text_store_default')));
        $options['store'] = $options['estimator_store'] = $this->ocm->form->getOptions($stores, 'store_id');

        $this->load->model('localisation/currency');
        $currencies = $this->model_localisation_currency->getCurrencies();
        $options['currency'] = $this->ocm->form->getOptions($currencies, 'currency_id');
      
        $cg_path = (VERSION >= '2.1.0.1') ? 'customer' : 'sale';
        $this->load->model($cg_path . '/customer_group');
        $customer_groups = $this->{'model_' . $cg_path . '_customer_group'}->getCustomerGroups();
        $customer_groups[] = array('customer_group_id' => 0, 'name' => $this->language->get('text_guest_checkout'));
        $options['customer_group'] = $this->ocm->form->getOptions($customer_groups, 'customer_group_id');

        $this->load->model('localisation/country');
        $countries = $this->model_localisation_country->getCountries();
        $options['country'] = $this->ocm->form->getOptions($countries, 'country_id');

        $options['payment'] = $this->ocm->misc->getPaymentMethods($data['language_id']);
        $options['shipping'] = $this->ocm->misc->getShippingMethods($data['language_id'], $geo_zones);

        $status_options = array('1' => $data['text_enabled'], '0' => $data['text_disabled']);
        $options['status'] = $options['debug'] = $this->ocm->form->getOptions($status_options, 'none');

        $inc_exc_options = array('inclusive' => $data['text_rule_inclusive'], 'exclusive' => $data['text_rule_exclusive']);
        $inc_exc_options = $this->ocm->form->getOptions($inc_exc_options, 'none');
        $options['city_rule'] = $options['coupon_rule'] = $options['postal_rule'] = $options['customer_rule'] = $inc_exc_options; 

        $product_rule_options = array(
            '' => $data['text_any'],
            '6' => $data['text_ones_any'],
            '3' => $data['text_ones_any_with_other'],
            '4' => $data['text_ones_must'],
            '2' => $data['text_ones_must_with_other'],
            '5' => $data['text_ones_except'],
            '7' => $data['text_ones_except_with_other'] 
        );
        $product_rule_options = $this->ocm->form->getOptions($product_rule_options, 'none');
        $options['category'] = $options['product'] = $options['option'] = $options['attribute'] = $options['manufacturer_rule'] = $options['location_rule'] = $product_rule_options; 

        $rate_type_options = array(
            'flat'            => $data['text_rate_flat'],
            'sub'             => $data['text_rate_sub_total'],
            'total'           => $data['text_rate_total'],
            'sub_special'     => $data['text_rate_sub_special'],
            'total_special'   => $data['text_total_special'],
            'quantity'        => $data['text_rate_quantity'],
            'weight'          => $data['text_rate_weight'],
            'equation'        => $data['text_rate_equation']
        );
        $options['rate_type'] = $this->ocm->form->getOptions($rate_type_options, 'none');

        $percent_options = array(
            'sub'                 => $data['text_percent_sub_total'],
            'total'               => $data['text_percent_total'],
            'sub_special'         => $data['text_rate_sub_special'],
            'total_special'       => $data['text_total_special'],
            'sub_shipping'        => $data['text_percent_sub_total_shipping'],
            'total_shipping'      => $data['text_percent_total_shipping'],
            'sub_shipping_plus'   => $data['text_percent_sub_total_shipping_plus'],
            'total_shipping_plus' => $data['text_percent_total_shipping_plus'],
            'shipping'            => $data['text_percent_shipping'],
            'shipping_plus'       => $data['text_percent_shipping_plus']
        );
        $options['rate_percent'] = $this->ocm->form->getOptions($percent_options, 'none');

        $week_day_optios = array(
            '0' => $data['text_sunday'],
            '1' => $data['text_monday'],
            '2' => $data['text_tuesday'],
            '3' => $data['text_wednesday'],
            '4' => $data['text_thursday'],
            '5' => $data['text_friday'],
            '6' => $data['text_saturday']
        );
        $options['days'] = $this->ocm->form->getOptions($week_day_optios, 'none');
        
        $yes_no_options = array('1' => $data['text_yes'], '0' => $data['text_no']);
        $modes = array(
            '0' => $data['text_mode_and'],
            '1' => $data['text_mode_or']
        );
        $options['product_or'] = $this->ocm->form->getOptions($modes, 'none');

        $custom_fields = $this->getCustomFields();
        $options['custom'] = $this->ocm->form->getOptions($custom_fields, 'custom_field_value_id');
        return $options;
    }
    public function load_method() {
       $ext_lang = $this->load->language($this->ext_path);
       /* Some help lang modificaiton */
       $ext_lang['help_time'] = sprintf($this->language->get('help_time'), date('h:i:s A'));
       $ext_lang['help_date'] = sprintf($this->language->get('help_date'), date('Y-m-d'));
       $this->load->model($this->ext_path);
       $json = array();
       $data = array();
       $data = array_merge($data, $ext_lang);
       $tab_id = isset($this->request->post['tab_id']) ? $this->request->post['tab_id'] : 0;

       $this->load->model('localisation/language');
       $languages = $this->model_localisation_language->getLanguages();
       $data['languages'] = $this->ocm->url->getLangImage($languages);
       $data['language_id'] = $this->config->get('config_language_id');
       $data['method_data'] = array($this->{$this->ext_key}->getDataByTabId($tab_id));
       $options = $this->getFormBuilderOptions($data);
       $this->ocm->form->setLangs($ext_lang)->setOptions($options);
       $json['html'] = $tab_id ? $this->getFormData($data) : '';
       $json['tab_id'] = $tab_id;
       $this->response->addHeader('Content-Type: application/json');
       $this->response->setOutput(json_encode($json)); 
    }
    // local events - on save
    public function onSave($save) {
       $_coupon = array();
       $_coupon['name'] = $this->request->post[$this->meta['name']]['display'];
       $_coupon['status'] = (int)$this->request->post[$this->meta['name']]['status'];
       $_coupon['uses_total'] = (int)$this->request->post[$this->meta['name']]['per_coupon'];
       $_coupon['uses_customer'] = (int)$this->request->post[$this->meta['name']]['per_customer'];
       $_coupon['name'] = $_coupon['name'] ? $_coupon['name'] : 'Untitled coupon';
       $this->{$this->ext_key}->updateCouponsByTabId($this->request->post['tab_id'], $_coupon);
    }
    // local events - on delete
    public function onDelete() {
       $this->{$this->ext_key}->deleteCouponByTabId($this->request->post['tab_id']);
    }
    /* Coupon mananger */
    public function addCoupon() {
        $this->load->language($this->ext_path);
        $this->load->model($this->ext_path);
        $json = array();
        $tab_id = $this->request->post['tab_id'];
        $display = $this->request->post['display'];
        $coupon_code = $this->request->post['coupon_code'];
        if (!$this->{$this->ext_key}->couponExist($coupon_code)) {
            $data = array();
            $data['name'] = $display ? $display : 'Untitled coupon';
            $data['code'] = $coupon_code;
            $json = $this->{$this->ext_key}->addCoupon($data);
            $this->{$this->ext_key}->addXCoupon($json['coupon_id'], $tab_id);
        } else {
            $json['error'] = $this->language->get('error_coupon_exist');
        }
        $this->response->setOutput(json_encode($json));
    }
    public function generateCoupons(){
        $this->load->model($this->ext_path);
        $json = array();
        $tab_id = $this->request->post['tab_id'];
        $display = $this->request->post['display'];
        $prefix = $this->request->post['prefix'];
        $length = (int)$this->request->post['length'];
        $total = (int)$this->request->post['total'];

        $data = array();
        $data['name'] = $display ? $display : 'Untitled coupon';
        $data['prefix'] = $prefix;
        $data['length'] = $length ? $length : 6;
        $data['total'] = $total ? $total : 10;
        $data['tab_id'] = $tab_id;
        $coupons = $this->{$this->ext_key}->addBatchCoupons($data);
        if ($coupons) {
            $json['coupons'] = $coupons;
        } else {
            $json['error'] = $this->language->get('error_coupon_generation');
        }
        $this->response->setOutput(json_encode($json));
    }
    public function searchCoupon() {
        $this->load->model($this->ext_path);
        $json = array();
        $tab_id = $this->request->post['tab_id'];
        $keyword = $this->request->post['filter'];
        $filter = array(
                'tab_id' => $tab_id,
                'filter' => $keyword,
                'start'  => 0,
                'limit'  => 10
        );
        $json['coupons'] = $this->{$this->ext_key}->getCoupons($filter);
        $total_coupon = $this->{$this->ext_key}->getTotalCoupons($filter);
        $json['avail'] = $total_coupon > 10;
        $this->response->setOutput(json_encode($json));
    }
    public function loadCoupon() {
        $this->load->model($this->ext_path);
        $json = array();
        $tab_id = $this->request->post['tab_id'];
        $page = (int)$this->request->post['page'];
        $keyword = $this->request->post['filter'];
        $filter = array(
                'tab_id' => $tab_id,
                'filter' => $keyword,
                'start'  => $page * 10,
                'limit'  => 10
        );
        $json['coupons'] = $this->{$this->ext_key}->getCoupons($filter);
        $total_coupon = $this->{$this->ext_key}->getTotalCoupons($filter);
        $json['avail'] = ($total_coupon > ($page * 10 + 10));
        $this->response->setOutput(json_encode($json));
    }
    public function deleteCoupon() {
        $this->load->model($this->ext_path);
        $json = array();
        $json['success'] = true;
        $coupon_id = $this->request->post['coupon_id'];
        $this->{$this->ext_key}->deleteCoupon($coupon_id);
        $this->response->setOutput(json_encode($json));
    }
    public function deleteCoupons() {
        $this->load->model($this->ext_path);
        $json = array();
        $json['success'] = true;
        $tab_id = $this->request->post['tab_id'];
        $selected = $this->request->post['selected'];
        $both = $this->request->post['both'];
        if ($selected) {
            foreach ($selected as $coupon_id) {
                $this->{$this->ext_key}->deleteCoupon($coupon_id, $both);
            }
        }
        $this->response->setOutput(json_encode($json));
    }
    public function deleteCouponAll() {
        $this->load->model($this->ext_path);
        $json = array();
        $json['success'] = true;
        $tab_id = $this->request->post['tab_id'];
        $this->{$this->ext_key}->deleteCouponByTabId($tab_id);
        $this->response->setOutput(json_encode($json));
    }
    public function getUnlinkedCoupons() {
        $this->load->model($this->ext_path);
        $filter = isset($this->request->post['filter']) ? $this->request->post['filter'] : array();
        $filter_data = array(
            'start'  => 0,
            'limit'  => 50
        );
        if (isset($filter['keyword']) && $filter['keyword']) {
            $filter_data['filter'] = $filter['keyword'];
        }
        $json = $this->{$this->ext_key}->getUnlinkedCoupons($filter_data);
        $this->response->setOutput(json_encode($json));
    }
    public function linkCoupons() {
        $this->load->model($this->ext_path);
        $tab_id = $this->request->post['tab_id'];
        $links = $this->request->post['links'];
        $json = array();
        $json['success'] = true;
        $this->{$this->ext_key}->linkedCoupons($tab_id, $links);
        $this->response->setOutput(json_encode($json));
    }
    /* End of coupon manager */
    public function export() {
        $this->load->model($this->ext_path);
        $tab_id = $this->request->get['tab_id'];
        $filter = array(
           'tab_id' => $tab_id
        );
        $coupons = $this->{$this->ext_key}->getCoupons($filter);
        $method = $this->{$this->ext_key}->getDataByTabId($tab_id);

        $fields = array('coupon_id','code');
        $content = $this->ocm->misc->getCSV($coupons, $fields);
        $filename = $method['method_data']['display'];
        if (!$filename) {
            $filename = $this->meta['name'];
        }
        $filename .= '.csv';
        $this->forceDownload($content, $filename);
    }
    private function getConfigForm($data) {
        /* Set base name for form inputs */
        $setting = $this->ocm->setting->getSetting($this->setting, $data['languages']);
        $this->ocm->form->setBasename($this->ocm->prefix . 'xcoupon_', 'prefix');
        $this->ocm->form->setPreset($setting)->setIDPostfix('');

        $return = '';
        $tabs = array(
            'global-general' => $data['tab_global_general'],
            'global-help' => $data['tab_help']
        );
        $return .= $this->ocm->misc->getTabs('global-tab', $tabs);
        $return .= '<div class="tab-content">';

        $return .= '<div class="tab-pane active" id="global-general">';
        $return .= $this->ocm->form->get('select', array('name' => 'status', 'title' => $data['entry_module_status'], 'help' => $data['help_module_status']));
        $return .= $this->ocm->form->get('select', 'debug');
        $return .= '</div>';

        $return .= '<div class="tab-pane" id="global-help">';
        $return .= '<div class="ocm-debug-button"><a class="btn btn-danger" href="javascript:debugBrowser();" role="button">'.$data['text_debug_button'].'</a></div>';
        $return .= $this->ocm->misc->getOCMInfo();
        $return .= '</div>';
        
        $return .= '</div>';
        return $return;
    }
    private function getFormData($data, $new_tab = false) {
        $this->load->model('catalog/category');
        $this->load->model('catalog/product');
        $this->load->model('catalog/option');
        $this->load->model('catalog/manufacturer');
        $cg_path = (VERSION >= '2.1.0.1') ? 'customer' : 'sale';
        $this->load->model($cg_path . '/customer');

        if ($new_tab) {
            $data['method_data'] = array(
                array('tab_id' => '__INDEX__', 'method_data' => array())
            );
        }
        /* Set base name for form inputs */
        $this->ocm->form->setBasename($this->meta['name']);
        $range_types = array('sub', 'total', 'sub_special', 'total_special', 'quantity', 'weight', 'grand', 'equation');
        $non_total_types = array('flat','quantity', 'weight', 'equation');

        $fields_all = array(
            'store'          => 'store_all',
            'geo_zone'       => 'geo_zone_all',
            'zone'           => 'zone_all',
            'country'        => 'country_all', 
            'customer_group' => 'customer_group_all',
            'payment'        => 'payment_all',
            'shipping'       => 'shipping_all',
            'days'           => 'days_all',
            'customers'      => 'customer_all',
            'custom'         => 'custom_all'
        );
        $default_values = $this->getDefaultValues();
        $return = '';
        $count = 0;
        foreach($data['method_data'] as $single_method) {
            $count++;
            $no_of_tab   = $single_method['tab_id'];
            $method_data = $single_method['method_data'];
            $method_data = $this->resetEmptyAll($method_data, $fields_all);
            $method_data = array_merge($default_values, $method_data);
            if (!$method_data['display']) {
                $method_data['display'] = 'Untitled Item';
            }
            // move this in commmon place in future
            if ($no_of_tab == '__INDEX__') {
                $method_data['method_specific'] = 1;
            }

            $filter = array(
                'tab_id' => $no_of_tab,
                'start'  => 0,
                'limit'  => 10
            );
            $method_data['coupons'] = $this->{$this->ext_key}->getCoupons($filter);
            $method_data['total_coupon'] = $this->{$this->ext_key}->getTotalCoupons($filter);
            $method_data['export'] = $this->ocm->url->link($this->ext_path . '/export', 'tab_id=' . $no_of_tab, true);
            $total_used = $this->{$this->ext_key}->getTotalUsed($filter);
            $usages_percent = $method_data['total_coupon'] ? (($total_used / $method_data['total_coupon']) * 100) : 0;
            $this->ocm->form->setPreset($method_data)->setIDPostfix($no_of_tab);
            $return .= '<div id="ocm-method-'.$no_of_tab.'" class="tab-pane xcoupon ocm-method">';
            if (!$new_tab && $count > 1) {
               $return .= '</div>';
               continue; 
            }
            $return .= '<div class="ocm-action-btn">';
            $return .= $this->ocm->misc->getButton(array('type' => 'success', 'help'=> $data['text_method_save'], 'class' => 'btn-ocm-save btn-sm', 'icon' => 'fa-save'));
            $return .= $this->ocm->misc->getButton(array('type' => 'warning', 'help'=> $data['text_method_copy'], 'class' => 'btn-ocm-copy btn-sm', 'icon' => 'fa-copy'));
            $return .= $this->ocm->misc->getButton(array('type' => 'danger', 'help'=> $data['text_method_remove'], 'class' => 'btn-ocm-delete btn-sm', 'icon' => 'fa-trash fa-trash-alt'));
            $return .= '</div>';

            $return .= $this->ocm->form->get('input', 'display');
            
            $tabs = array(
                'common_' . $no_of_tab    => $data['tab_general'],
                'criteria_' . $no_of_tab    => $data['tab_criteria_setting'],
                'catprod_' . $no_of_tab     => $data['tab_category_product'],
                'price_' . $no_of_tab       => $data['tab_coupon_setting'],
                'coupons_' . $no_of_tab     => $data['tab_coupon_options']
            );
            $return .= $this->ocm->misc->getTabs('method-tab' . $no_of_tab, $tabs);

            $return .= '<div class="tab-content">';
            $return .= '<div class="tab-pane active" id="common_' . $no_of_tab . '">';
            $return .= $this->ocm->form->get('select', 'tax_class_id');
            $return .= $this->ocm->form->get('select', 'status');
            $return .= '</div>';
            $return .= '<div class="tab-pane" id="criteria_'.$no_of_tab.'">';

            $zones = $this->getZones($method_data['country']);
            $zones = $this->ocm->form->getOptions($zones, 'zone_id');

            $return .= $this->ocm->form->get('checkgroup', 'store[]');
            $return .= $this->ocm->form->get('checkgroup', 'customer_group[]');
            $return .= $this->ocm->form->get('checkgroup', array('name' => 'geo_zone[]', 'search' => true));
            $return .= $this->ocm->form->get('checkgroup', array('name' => 'country[]', 'search' => true));
            $return .= $this->ocm->form->get('checkgroup', array('name' => 'zone[]', 'options' => $zones, 'search' => true));
            $return .= $this->ocm->form->get('checkgroup', 'payment[]');
            $return .= $this->ocm->form->get('checkgroup', 'shipping[]');
            $return .= $this->ocm->form->get('checkgroup', array('name' => 'custom[]', 'search' => true));

            /* cunstomers */
            $customers = array();
            foreach ($method_data['customers'] as $customer_id) {
                $customer_info = $this->{'model_' . $cg_path . '_customer'}->getCustomer($customer_id);
                if ($customer_info) {
                    $name = strip_tags(html_entity_decode($customer_info['firstname'], ENT_QUOTES, 'UTF-8')) . ' ' . strip_tags(html_entity_decode($customer_info['lastname'], ENT_QUOTES, 'UTF-8')) . ' (ID: '.$customer_id.')';
                    $customers[] = array(
                        'customer_id' => $customer_id,
                        'name'  => $name
                    );
                }
            }
            /* Customer */
            $visible = !$method_data['customer_all'];
            $customers = $this->ocm->form->getOptions($customers, 'customer_id');
            $groups = array();
            $groups['checkbox'] = array('name' => 'customer_all', 'label' => $data['text_any']);
            $groups['autofill'] = array('name' => 'customers[]', 'attr'  => 'customer_all', 'options' => $customers, 'visible' => $visible);
            $groups['select'] = array('name' => 'customer_rule', 'attr' => 'customer_all', 'visible' => $visible);
            $return .= $this->ocm->form->getFrom($groups);
            /* end of customers */
            $return .= $this->ocm->form->get('checkbox', array('name' => 'first', 'label' => $data['text_first']));

            $return .= $this->ocm->form->get('checkgroup', 'days[]');
            $return .= $this->ocm->form->get('range', array('name' => 'time', 'type' => 'time'));
            $return .= $this->ocm->form->get('range', array('name' => 'date', 'type' => 'date'));
            $return .= $this->ocm->form->get('input', 'per_coupon');
            $return .= $this->ocm->form->get('input', 'per_customer');

            $return .= '</div>';
            $return .= '<div class="tab-pane" id="catprod_'.$no_of_tab.'">';

            /* categories */
            $categories = array();
            foreach ($method_data['product_category'] as $category_id) {
               $category_info = $this->model_catalog_category->getCategory($category_id);
                if ($category_info) {
                    if ($category_info['path']) $category_info['path'] .=  '&nbsp;&nbsp;&gt;&nbsp;&nbsp;';
                    $categories[] = array(
                        'category_id' => $category_id,
                        'name'       => $category_info['path'].$category_info['name']
                    );
                }
            }

            $visible = (int)$method_data['category'] > 1;
            $return .= $this->ocm->form->get('select', 'category');
            $param = array(
                'name'  => 'product_category[]',
                'options' => $this->ocm->form->getOptions($categories, 'category_id'),
                'attr'  => 'category',
                'browser' => 'category',
                'visible' => $visible
            );
            $return .= $this->ocm->form->get('autofill', $param);

            /* Products  */
            $products = array();
            foreach ($method_data['product_product'] as $product_id) {
               $product_info = $this->model_catalog_product->getProduct($product_id);
               if ($product_info) {
                    $products[] = array(
                        'product_id' => $product_id,
                        'name'       => $product_info['name']
                    );
               }
            }
            
            $visible = (int)$method_data['product'] > 1;
            $return .= $this->ocm->form->get('select', 'product');
            $param = array(
                'name'  => 'product_product[]',
                'options' => $this->ocm->form->getOptions($products, 'product_id'),
                'attr'  => 'product',
                'browser' => 'product',
                'visible' => $visible
            );
            $return .= $this->ocm->form->get('autofill', $param);

            /* Product Options  */
            $options = array();
            foreach ($method_data['product_option'] as $option_value_id) {
               $option_value_info = $this->model_catalog_option->getOptionValue($option_value_id);
               if ($option_value_info) {
                    $option_info = $this->model_catalog_option->getOption($option_value_info['option_id']);
                    if ($option_info) {
                        $options[] = array(
                            'option_value_id' => $option_value_id,
                            'name'            => strip_tags(html_entity_decode($option_info['name'], ENT_QUOTES, 'UTF-8')).'&nbsp;&nbsp;&gt;&nbsp;&nbsp;' . strip_tags(html_entity_decode($option_value_info['name'], ENT_QUOTES, 'UTF-8'))
                        );
                    }
               }
            }
            
            $visible = (int)$method_data['option'] > 1;
            $return .= $this->ocm->form->get('select', 'option');
            $param = array(
                'name'  => 'product_option[]',
                'options' => $this->ocm->form->getOptions($options, 'option_value_id'),
                'attr'  => 'option',
                'visible' => $visible
            );
            $return .= $this->ocm->form->get('autofill', $param);

            /* Product attribute  */
            $options = array();
            foreach ($method_data['product_attribute'] as $attribute_id) {
                $attribute = $this->{$this->ext_key}->getAttribute($attribute_id);
                if ($attribute) {
                    $options[] = array(
                        'attribute_id' => $attribute_id,
                        'name'         => strip_tags(html_entity_decode($attribute['attribute_group'], ENT_QUOTES, 'UTF-8')) . '&nbsp;&nbsp;&gt;&nbsp;&nbsp;' . strip_tags(html_entity_decode($attribute['name'], ENT_QUOTES, 'UTF-8'))
                    );
                }
            }
            
            $visible = (int)$method_data['attribute'] > 1;
            $return .= $this->ocm->form->get('select', 'attribute');
            $param = array(
                'name'  => 'product_attribute[]',
                'options' => $this->ocm->form->getOptions($options, 'attribute_id'),
                'attr'  => 'attribute',
                'visible' => $visible
            );
            $return .= $this->ocm->form->get('autofill', $param);

            /* Manufacturer  */
            $manufacturers = array();
            foreach ($method_data['manufacturer'] as $manufacturer_id) {
                $manufacturer_info = $this->model_catalog_manufacturer->getManufacturer($manufacturer_id);
                if ($manufacturer_info) {
                    $manufacturers[] = array(
                        'manufacturer_id' => $manufacturer_id,
                        'name'            => $manufacturer_info['name']
                    );
                }
            }

            $visible = (int)$method_data['manufacturer_rule'] > 1;
            $return .= $this->ocm->form->get('select', 'manufacturer_rule');
            $param = array(
                'name'    => 'manufacturer[]',
                'options' => $this->ocm->form->getOptions($manufacturers, 'manufacturer_id'),
                'attr'    => 'manufacturer_rule',
                'browser' => 'manufacturer',
                'visible' => $visible
            );
            $return .= $this->ocm->form->get('autofill', $param);

            /* Locations  */
            $locations = array();
            foreach ($method_data['location'] as $location) {
                if ($location) {
                    $locations[] = array(
                        'value'  => $location,
                        'name'   => $location
                    );
                }
            }

            $visible = (int)$method_data['location_rule'] > 1;
            $return .= $this->ocm->form->get('select', 'location_rule');
            $param = array(
                'name'  => 'location[]',
                'options' => $locations,
                'attr'  => 'location_rule',
                'visible' => $visible
            );
            $return .= $this->ocm->form->get('autofill', $param);

            $return .= $this->ocm->form->get('select', 'product_or');

            $return .= '</div>';

            $return .= '<div class="tab-pane" id="price_'.$no_of_tab.'">';

            $return .= $this->ocm->form->get('select', 'rate_type');
            $return .= $this->ocm->form->get('checkbox', array('name' => 'method_specific', 'label' => $data['text_method_specific']));

            $return .= $this->ocm->form->get('input', array('name' => 'cost', 'visible' => $method_data['rate_type']=='flat', 'class' => 'rate_type ocm-hide flat'));

            $element = $this->getRanges($method_data, $data, $no_of_tab);
            $return .= $this->ocm->form->get('bare', array('name' => 'unit_range', 'label_col' => 0, 'element' => $element, 'visible' => $method_data['rate_type'] != 'flat', 'class' => 'rate_type ocm-hide product ' . implode(' ', $range_types)));

            $return .= $this->ocm->form->get('checkbox', array('name' => 'freeship', 'label' => $data['text_freeship']));

            $visible =  in_array($method_data['rate_type'], $non_total_types); 
            $return .= $this->ocm->form->get('range', array('name' =>'total', 'visible' => $visible, 'class' => 'rate_type ocm-hide ' . implode(' ', $non_total_types)));
            
            $visible = $method_data['rate_type'] != 'weight';
            $return .= $this->ocm->form->get('range', array('name' =>'weight', 'visible' => $visible, 'class' => 'rate_type ocm-hide flat ' . implode(' ', array_diff($range_types, array('weight')))));
            
            $visible = $method_data['rate_type'] != 'quantity';
            $return .= $this->ocm->form->get('range', array('name' =>'quantity', 'visible' => $visible, 'class' => 'rate_type ocm-hide flat ' . implode(' ', array_diff($range_types, array('quantity')))));

            $return .= $this->ocm->form->get('select', 'rate_percent');
            $return .= $this->ocm->form->get('input', 'max');
            $return .= $this->ocm->form->get('checkbox', array('name' => 'non_zero', 'label' => $data['text_non_zero']));
            $return .= $this->ocm->form->get('textarea', 'equation');
            $return .= '</div>';

            $return .= '<div class="tab-pane" id="coupons_' . $no_of_tab . '">';
            $return .= '<div class="coupons-stats">';
            $return .= '<span><b>' . $data['text_total_coupon'] . '</b>&nbsp;&nbsp;' . $method_data['total_coupon'] . '</span>';
            $return .= '<span><b>' . $data['text_total_used'] . '</b>&nbsp;&nbsp;' . $total_used . ' (' . $usages_percent . '%)</span>';
            $return .= '</div>';
            $return .= '<div class="coupon-fitlers">';
            $return .= '<label class="filter-label">' . $data['text_filter'] .'</label>';
            $return .= '<div class="filter-input"><input type="text" name="coupon_filter" value="" placeholder="' . $data['text_filter_placehoder'] .'" class="form-control coupon-filter-text"></div>';
            $return .= '<button class="btn btn-default btn-coupon-fitler" type="button">' . $data['btn_coupon_filter'] .'</button>';
            $return .= '</div>';
            $element =  $this->getCoupons($method_data, $data, $no_of_tab);
            $return .= $this->ocm->form->get('bare', array('name' => 'coupon_list', 'label_col' => 0, 'element' => $element));
            $return .= '</div>';

            $return .= '</div>';
            $return .= '</div>';
        }
        return $return;
    }
    private function getDefaultValues() {
        return array(
            /* array rules */   
            'customer_group'    => array(),
            'geo_zone'          => array(),
            'product_category'  => array(),
            'product_product'   => array(),
            'store'             => array(),
            'currency'          => array(),
            'payment'           => array(),
            'shipping'          => array(),
            'manufacturer'      => array(),
            'days'              => array(),
            'products'          => array(),
            'country'           => array(),
            'zone'              => array(),
            'product_option'    => array(),
            'product_attribute' => array(),
            'location'          => array(),
            'customers'         => array(),
            'ranges'            => array(),
            'coupons'           => array(),
            'custom'            => array(),
            /* string/numberic rules*/
            'customer_group_all' => '',
            'geo_zone_all'       => '',
            'country_all'        => '',
            'zone_all'           => '',
            'store_all'          => '',
            'manufacturer_all'   => '',
            'payment_all'        => '',
            'shipping_all'       => '',
            'days_all'           => '',
            'customer_all'       => '',
            'custom_all'         => '',
            'customer_rule'      => 'inclusive',
            'time_start'         => '',
            'time_end'           => '',
            'location_rule'      => '',
            'manufacturer_rule'  => '',
            'total_start'        => '',
            'total_end'          => '',
            'weight_start'       => '',
            'weight_end'         => '',
            'quantity_start'     => '',
            'quantity_end'       => '',
            'equation'           => '',
            'option'             => 1,
            'attribute'          => 1,
            'status'             =>  1,
            'category'           => '',
            'product'            => '',
            'rate_type'          => 'flat',
            'display'            => 'Untitled Item',
            'product_or'         => '1',
            'first'              => '',
            'method_specific'    => '',
            'freeship'           => '',
            'non_zero'           => '',
            'date_start'         => '',
            'date_end'           => ''
        );
    }
    private function getCoupons($method_data, $data, $no_of_tab) {
        $fields = array('start', 'end', 'cost');
        $return = '';
        $return .='<div class="coupon-container">
                    <div class="ocm-range-option">';
        $return .= $this->ocm->misc->getButton(array('type' => 'success', 'title' => $data['btn_add_coupon'], 'class' => 'btn-coupon-add btn-sm', 'icon' => 'fa-plus'));
        $return .= $this->ocm->misc->getButton(array('type' => 'primary', 'title' => $data['btn_generate_coupon'], 'class' => 'btn-coupon-generate btn-sm', 'icon' => 'fa-bullseye'));
        $return .= $this->ocm->misc->getButton(array('type' => 'info', 'title' => $data['btn_link_coupon'], 'class' => 'btn-coupon-link btn-sm', 'icon' => 'fa-link'));
        $return .= '<a href="' . $method_data['export'] . '" target="_blank" class="btn btn-sm btn-warning"><i class="fa fas fa-download fa-file-csv"></i> ' . $data['btn_export_coupon'] . '</a>';
        $return .= '<div class="btn-group">';
        $return .= '<button class="btn btn-danger btn-sm dropdown-toggle" type="button" data-toggle="dropdown">';
        $return .= '<i class="fa fas fa-trash fa-trash-alt"></i> ' . $data['btn_delete_all_coupon'];
        $return .= '&nbsp;<span class="caret"></span>';
        $return .= '</button>';
        $return .= '<div class="dropdown-menu">';
        $return .='<a class="dropdown-item btn-coupon-unlink-batch">' . $data['text_unlink_only'] . '</a>';
        $return .='<a class="dropdown-item btn-coupon-remove-batch">' . $data['text_delete_coupon'] . '</a>';
        $return .='<a class="dropdown-item btn-coupon-remove-all">' . $data['text_delete_all'] . '</a>';
        $return .='</div>';
        $return .= '</div>';
        $return .= '</div>';

        $table_body = '';
        foreach ($method_data['coupons'] as $coupon) {
            $table_body .= '<tr rel="'.$coupon['coupon_id'].'">' 
                            .'<td width="20" class="text-center"><input type="checkbox" name="selected[]" value="'.$coupon['coupon_id'].'"></td>'
                            .'<td width="100" class="text-left">' . $coupon['coupon_id'] . '</td>'
                            .'<td class="text-left">' . $coupon['name'] . '</td>'
                            .'<td class="text-left">' . $coupon['code'] . '</td>'
                            .'<td width="125" class="text-right"><a class="btn btn-sm btn-danger btn-coupon-remove">'.$data['text_remove'].'</a></td>'
                        .'</tr>';
        }
        if (!$method_data['coupons']) $table_body .= '<tr class="no-row"><td colspan="5">'.$data['text_no_coupons'].'</td></tr>';

        $table_headings = array(
            array(
                'title'  => '<input class="checkbox-all" type="checkbox">',
            ),
            array(
                'title'  => $data['text_coupon_id'],
            ),
            array(
                'title'  => $data['text_coupon_name']
            ),
            array(
                'title'  => $data['text_coupon_code']
            ),
            array(
                'title' => $data['text_action']
            )
        );
        $return .= $this->ocm->misc->getTableSkeleton($table_headings, $table_body);
        if ($method_data['total_coupon'] > 10) {
            $return .= '<div page="1" class="coupon-load-more">' . $this->ocm->misc->getButton(array('type' => 'default', 'title' => $data['btn_load_coupons'], 'class' => 'btn-load-coupon btn-sm', 'icon' => 'fa-caret-down')) . '</div>';
        }
        $return .=  '</div>';
        return $return;
    }
    private function getRanges($method_data, $data, $no_of_tab) {
        $fields = array('start', 'end', 'cost');
        $return = '';
        $return .='<div class="ocm-range-container">
                    <div class="ocm-range-option">';
        $return .= '   <div class="price-range">'.$data['entry_unit_range'].'</div>';
        $return .=     $this->ocm->misc->getButton(array('type' => 'danger', 'title'=> $data['text_delete_all'], 'class' => 'ocm-row-remove-all btn-sm range-btn'));
        $return .= '</div>';

        $ranges = array();
        foreach ($method_data['ranges'] as $counter => $range) {
            foreach ($fields as $field) {
                if (!isset($range[$field])) {
                    $range[$field] = '';
                }
            }
            $ranges[] = $range;
        }
        $table_body = '';
        foreach ($ranges as $counter => $range) {
            $table_body .= '<tr rel="'.$counter.'">' 
                            .'<td class="text-left"><input size="15" type="text" class="form-control" name="xcoupon[ranges]['.$counter.'][start]" value="' . $range['start'] . '" /></td>'
                            .'<td class="text-left"><input size="15" type="text" class="form-control" name="xcoupon[ranges]['.$counter.'][end]" value="' . $range['end'] . '" /></td>'
                            .'<td class="text-left"><input size="15" type="text" class="form-control" name="xcoupon[ranges]['.$counter.'][cost]" value="' . $range['cost'] . '" /></td>'
                            .'<td class="text-right"><a class="btn btn-sm btn-danger ocm-row-remove">'.$data['text_remove'].'</a></td>'
                        .'</tr>';
        }
        if (!$method_data['ranges']) $table_body .= '<tr class="no-row"><td colspan="4">'.$data['text_no_unit_row'].'</td></tr>';

        $table_headings = array(
            array(
                'title'  => $data['text_start'],
                'help'   => $data['help_unit_start']
            ),
            array(
                'title'  => $data['text_end'],
                'help'   => $data['help_unit_end']
            ),
            array(
                'title' => $data['text_cost'],
                'help'  => $data['help_unit_price']
            ),
            array(
                'title' => $data['text_action']
            )
        );

        $table_footer = '<tfoot>
                           <td colspan="7" class="text-right">&nbsp;';
        $table_footer .= $this->ocm->misc->getButton(array('type' => 'primary', 'title'=> $data['text_add_new'], 'class' => 'add-ocm-row', 'icon' => 'fa-plus-circle'));
        $table_footer .= '</tr>
                        </tfoot>';
        $return .= $this->ocm->misc->getTableSkeleton($table_headings, $table_body, $table_footer);
        $return .=  '</div>';
        return $return;
    }
    /* admin event */
    public function onColumnLeft($route, &$data) {
        if (VERSION >= '2.3.0.0' && $this->user->hasPermission('access', $this->ext_path)) {
            $menu = array(
                'id'       => 'menu-coupon',
                'icon'     => ' fa fa-tag', 
                'name'     => $this->meta['title'],
                'href'     => $this->ocm->url->getExtensionURL(),
                'children' => array()
            );
            array_push($data['menus'], $menu);
        }
    }
 }