<?php
class ControllerExtensionModuleGoogleTranslate extends Controller {
    private $error = array();
    private $mName 			    = 'module_google_translate';
    private $mPath 		        = 'extension/module/google_translate';
    private $mModel 			= 'model_extension_module_google_translate';
    private $mVersion 			= '1.2';
    private $token 			    = 'user_token';
    private $ssl 			    = true;

    public function index() {
        $lang_ar = $this->load->language($this->mPath);
        foreach($lang_ar as $key => $item){
            $data[$key] = $item;
        }

        $this->document->setTitle($this->language->get('heading_title_main'));

        $this->load->model('setting/store');

        $data['breadcrumbs'] = array();

        $data['breadcrumbs'][] = array(
            'text' => $this->language->get('text_home'),
            'href' => $this->url->link('common/dashboard', $this->token . '=' . $this->session->data[$this->token], $this->ssl)
        );

        $data['breadcrumbs'][] = array(
            'text' => $this->language->get('text_module'),
            'href' => $this->url->link('marketplace/extension', $this->token . '=' . $this->session->data[$this->token] . '&type=module', $this->ssl)
        );

        $data['breadcrumbs'][] = array(
            'text' => $this->language->get('text_list'),
            'href' => $this->url->link($this->mPath, $this->token . '=' . $this->session->data[$this->token], $this->ssl)
        );

        $data['cancel'] = $this->url->link('marketplace/extension', $this->token . '=' . $this->session->data[$this->token] . '&type=module', $this->ssl);

        $data['stores'] = array();

        $this->load->model('tool/image');

        if (is_file(DIR_IMAGE . $this->config->get('config_logo'))) {
            $image = $this->model_tool_image->resize($this->config->get('config_logo'), 40, 40);
        } else {
            $image = $this->model_tool_image->resize('no_image.png', 40, 40);
        }

        $data['stores'][] = array(
            'store_id' => 0,
            'name'     => $this->config->get('config_name') . ' (' . $this->language->get('text_default') . ')',
            'url'      => HTTP_CATALOG,
            'image'    => $image,
            'edit'     => $this->url->link($this->mPath . '/edit', $this->token . '=' . $this->session->data[$this->token] . '&store_id=0', $this->ssl)
        );

        $results = $this->model_setting_store->getStores();
        $this->load->model('setting/setting');

        foreach ($results as $result) {
            $store_info = $this->model_setting_setting->getSetting('config', $result['store_id']);
            if (is_file(DIR_IMAGE . $store_info['config_logo'])) {
                $image = $this->model_tool_image->resize($store_info['config_logo'], 40, 40);
            } else {
                $image = $this->model_tool_image->resize('no_image.png', 40, 40);
            }
            $data['stores'][] = array(
                'store_id' => $result['store_id'],
                'name'     => $result['name'],
                'url'      => $result['url'],
                'image'    => $image,
                'edit'     => $this->url->link($this->mPath . '/edit', $this->token . '=' . $this->session->data[$this->token] . '&store_id=' . $result['store_id'], $this->ssl)
            );
        }

        if (isset($this->error['warning'])) {
            $data['error_warning'] = $this->error['warning'];
        } else {
            $data['error_warning'] = '';
        }

        if (isset($this->session->data['success'])) {
            $data['success'] = $this->session->data['success'];

            unset($this->session->data['success']);
        } else {
            $data['success'] = '';
        }

        $data['header'] = $this->load->controller('common/header');
        $data['column_left'] = $this->load->controller('common/column_left');
        $data['footer'] = $this->load->controller('common/footer');

        $this->response->setOutput($this->load->view($this->mPath, $data));
    }


    public function edit() {
        $lang_ar = $this->load->language($this->mPath);
        foreach($lang_ar as $key => $item){
            $data[$key] = $item;
        }

        $this->load->model($this->mPath);

        $this->document->setTitle($this->language->get('heading_title_main'));

        $this->load->model('setting/setting');

        if (($this->request->server['REQUEST_METHOD'] == 'POST') && $this->validate()) {

            $this->model_setting_setting->editSetting($this->mName, $this->request->post, $this->request->get['store_id']);

            $this->session->data['success'] = $this->language->get('text_success');

            if(!$this->request->post['apply']) {
                $this->response->redirect($this->url->link($this->mPath, $this->token . '=' . $this->session->data[$this->token], $this->ssl));
            }
        }

        if (isset($this->error['warning'])) {
            $data['error_warning'] = $this->error['warning'];
        } else {
            $data['error_warning'] = '';
        }

        $data['breadcrumbs'] = array();

        $data['breadcrumbs'][] = array(
            'text' => $this->language->get('text_home'),
            'href' => $this->url->link('common/dashboard', $this->token . '=' . $this->session->data[$this->token], $this->ssl)
        );

        $data['breadcrumbs'][] = array(
            'text' => $this->language->get('text_module'),
            'href' => $this->url->link('marketplace/extension', $this->token . '=' . $this->session->data[$this->token] . '&type=module', $this->ssl)
        );

        $data['breadcrumbs'][] = array(
            'text' => $this->language->get('text_list'),
            'href' => $this->url->link($this->mPath, $this->token . '=' . $this->session->data[$this->token], $this->ssl)
        );

        $data['breadcrumbs'][] = array(
            'text' => $this->language->get('heading_title_main'),
            'href' => $this->url->link($this->mPath . '/edit', $this->token . '=' . $this->session->data[$this->token] . '&store_id=' . $this->request->get['store_id'], $this->ssl)
        );

        $data['action'] = html_entity_decode($this->url->link($this->mPath . '/edit', $this->token . '=' . $this->session->data[$this->token] . '&store_id=' . $this->request->get['store_id'], $this->ssl));

        $data['cancel'] = html_entity_decode($this->url->link($this->mPath, $this->token . '=' . $this->session->data[$this->token], $this->ssl));

        $data['notification'] = html_entity_decode('index.php?route=extension/module/google_translate/getNotification&' . $this->token . '=' . $this->session->data[$this->token]);

        $data['store_id'] = $this->request->get['store_id'];
        if (isset($this->request->get['translator'])) {
            $data['translator'] = $this->request->get['translator'];
        }

        if (isset($this->request->get['store_id']) && ($this->request->server['REQUEST_METHOD'] != 'POST')) {
            $this->load->model('setting/setting');

            $store_info = $this->model_setting_setting->getSetting($this->mName, $this->request->get['store_id']);
        }

        if (isset($this->request->post['module_google_translate_status'])) {
            $data['module_google_translate_status'] = $this->request->post['module_google_translate_status'];
        } elseif (isset($store_info['module_google_translate_status'])) {
            $data['module_google_translate_status'] = $store_info['module_google_translate_status'];
        } else {
            $data['module_google_translate_status'] = 0;
        }

        if (isset($this->request->post['module_google_translate_language'])) {
            $data['module_google_translate_language'] = $this->request->post['module_google_translate_language'];
        } elseif (isset($store_info['module_google_translate_language'])) {
            $data['module_google_translate_language'] = $store_info['module_google_translate_language'];
        } else {
            $data['module_google_translate_language'] = 0;
        }

        if (isset($this->request->post['module_google_translate_specific'])) {
            $data['module_google_translate_specific'] = $this->request->post['module_google_translate_specific'];
        } elseif (isset($store_info['module_google_translate_specific'])) {
            $data['module_google_translate_specific'] = $store_info['module_google_translate_specific'];
        } else {
            $data['module_google_translate_specific'] = 0;
        }

        if (isset($this->request->post['module_google_translate_languages'])) {
            $data['module_google_translate_languages'] = $this->request->post['module_google_translate_languages'];
        } elseif (isset($store_info['module_google_translate_languages'])) {
            $data['module_google_translate_languages'] = $store_info['module_google_translate_languages'];
        } else {
            $data['module_google_translate_languages'] = array();
        }

        if (isset($this->request->post['module_google_translate_start_language'])) {
            $data['module_google_translate_start_language'] = $this->request->post['module_google_translate_start_language'];
        } elseif (isset($store_info['module_google_translate_start_language'])) {
            $data['module_google_translate_start_language'] = $store_info['module_google_translate_start_language'];
        } else {
            $data['module_google_translate_start_language'] = '';
        }

        if (isset($this->request->post['module_google_translate_multiple'])) {
            $data['module_google_translate_multiple'] = $this->request->post['module_google_translate_multiple'];
        } elseif (isset($store_info['module_google_translate_multiple'])) {
            $data['module_google_translate_multiple'] = $store_info['module_google_translate_multiple'];
        } else {
            $data['module_google_translate_multiple'] = 0;
        }

        if (isset($this->request->post['module_google_translate_track'])) {
            $data['module_google_translate_track'] = $this->request->post['module_google_translate_track'];
        } elseif (isset($store_info['module_google_translate_track'])) {
            $data['module_google_translate_track'] = $store_info['module_google_translate_track'];
        } else {
            $data['module_google_translate_track'] = 0;
        }

        if (isset($this->request->post['module_google_translate_analytics_id'])) {
            $data['module_google_translate_analytics_id'] = $this->request->post['module_google_translate_analytics_id'];
        } elseif (isset($store_info['module_google_translate_analytics_id'])) {
            $data['module_google_translate_analytics_id'] = $store_info['module_google_translate_analytics_id'];
        } else {
            $data['module_google_translate_analytics_id'] = '';
        }

        if (isset($this->request->post['module_google_translate_view'])) {
            $data['module_google_translate_view'] = $this->request->post['module_google_translate_view'];
        } elseif (isset($store_info['module_google_translate_view'])) {
            $data['module_google_translate_view'] = $store_info['module_google_translate_view'];
        } else {
            $data['module_google_translate_view'] = 0;
        }

        if (isset($this->request->post['module_google_translate_logo'])) {
            $data['module_google_translate_logo'] = $this->request->post['module_google_translate_logo'];
        } elseif (isset($store_info['module_google_translate_logo'])) {
            $data['module_google_translate_logo'] = $store_info['module_google_translate_logo'];
        } else {
            $data['module_google_translate_logo'] = 0;
        }

        if (isset($this->request->post['module_google_translate_bar'])) {
            $data['module_google_translate_bar'] = $this->request->post['module_google_translate_bar'];
        } elseif (isset($store_info['module_google_translate_bar'])) {
            $data['module_google_translate_bar'] = $store_info['module_google_translate_bar'];
        } else {
            $data['module_google_translate_bar'] = 0;
        }

        if (isset($this->request->post['module_google_translate_class'])) {
            $data['module_google_translate_class'] = $this->request->post['module_google_translate_class'];
        } elseif (isset($store_info['module_google_translate_class'])) {
            $data['module_google_translate_class'] = $store_info['module_google_translate_class'];
        } else {
            $data['module_google_translate_class'] = '';
        }

        if (isset($this->request->post['module_google_translate_style'])) {
            $data['module_google_translate_style'] = $this->request->post['module_google_translate_style'];
        } elseif (isset($store_info['module_google_translate_style'])) {
            $data['module_google_translate_style'] = $store_info['module_google_translate_style'];
        } else {
            $data['module_google_translate_style'] = '';
        }

        if (isset($this->request->post['module_google_translate_label'])) {
            $data['module_google_translate_label'] = $this->request->post['module_google_translate_label'];
        } elseif (isset($store_info['module_google_translate_label'])) {
            $data['module_google_translate_label'] = $store_info['module_google_translate_label'];
        } else {
            $data['module_google_translate_label'] = '';
        }

        if(!$this->request->get['store_id']){
            if (isset($this->request->post['module_google_translate_order_id'])) {
                $data['module_google_translate_order_id'] = $this->request->post['module_google_translate_order_id'];
            } elseif (isset($store_info['module_google_translate_order_id'])) {
                $data['module_google_translate_order_id'] = $store_info['module_google_translate_order_id'];
            } else {
                $data['module_google_translate_order_id'] = '';
            }

            if (isset($this->request->post['module_google_translate_url'])) {
                $data['module_google_translate_url'] = $this->request->post['module_google_translate_url'];
            } elseif (isset($store_info['module_google_translate_url'])) {
                $data['module_google_translate_url'] = $store_info['module_google_translate_url'];
            } else {
                $data['module_google_translate_url'] = '';
            }
        }
        
        if (isset($this->session->data['success'])) {
            $data['success'] = $this->session->data['success'];

            unset($this->session->data['success']);
        } else {
            $data['success'] = '';
        }

        $data['languages'] = $this->getLanguages();

        $data['header'] = $this->load->controller('common/header');
        $data['column_left'] = $this->load->controller('common/column_left');
        $data['footer'] = $this->load->controller('common/footer');

        $this->response->setOutput($this->load->view($this->mPath . '_edit', $data));
    }

    public function install() {
        $this->load->model('setting/store');
        $this->load->model('setting/setting');
        $this->load->model($this->mPath);
        $settings = array(
            'module_google_translate_status' => 1,
            'module_google_translate_language' => 'en',
            'module_google_translate_languages' => array(),
            'module_google_translate_specific' => 0,
            'module_google_translate_multiple' => 0,
            'module_google_translate_track' => 0,
            'module_google_translate_analytics_id' => '',
            'module_google_translate_view' => 0,
            'module_google_translate_logo' => 1,
            'module_google_translate_bar' => 1,
            'module_google_translate_class' => 'language-select',
            'module_google_translate_style' => '.google-translate-mod{ float: left; }
#google_translate_element .language-select{ margin-top: 7px; }
.language-currency .google-translate-mod{ pointer-events: all; }',
            'module_google_translate_label' => ''
        );
        $stores = $this->model_setting_store->getStores();
        $this->model_setting_setting->editSetting($this->mName, $settings, 0);
        foreach ($stores as $store) {
            $this->model_setting_setting->editSetting($this->mName, $settings, $store['store_id']);
        }
        $result = $this->{$this->mModel}->install();
        if($result->num_rows){
            $this->load->controller('marketplace/modification/refresh', array('redirect' => 'extension/extension/module'));
        }
    }

    public function uninstall() {
        $this->load->model('setting/store');
        $this->load->model('setting/setting');
        $this->load->model($this->mPath);
        $this->model_setting_setting->deleteSetting($this->mName,0);
        $stores = $this->model_setting_store->getStores();
        foreach ($stores as $store) {
            $this->model_setting_setting->deleteSetting($this->mName, $store['store_id']);
        }
        $result = $this->{$this->mModel}->uninstall();
        if($result->num_rows){
            $this->load->controller('marketplace/modification/refresh', array('redirect' => 'extension/extension/module'));
        }
    }

    protected function validate() {
        if (!$this->user->hasPermission('modify', $this->mPath)) {
            $this->error['warning'] = $this->language->get('error_permission');
        }
        return !$this->error;
    }

    public function getNotification() {
        sleep(1);
        $this->load->language($this->mPath);
        $site = $this->config->get('config_secure')?HTTPS_CATALOG:HTTP_CATALOG;
        $url = "https://vanstudio.co.ua/index.php?route=module/activation/info&extension_id=30172&site=" . $site . "&order_id=".$this->config->get('module_google_translate_order_id')."&url=".$this->config->get('module_google_translate_url')."&version=$this->mVersion&language_code=" . $this->config->get('config_admin_language');
        $output = file_get_contents($url);
        if (stripos($output,'<html') !== false || $output == false) {
            $json['message'] = '';
            $json['error'] = $this->language->get('error_message');
        } else {
            $json['message'] = $output;
            $json['error'] = '';
        }
        $this->response->setOutput(json_encode($json));
    }

    protected function getLanguages() {
        return array(
            'af' => 'Afrikaans',
            'sq' => 'Albanian',
            'am' => 'Amharic',
            'ar' => 'Arabic',
            'hy' => 'Armenian',
            'az' => 'Azerbaijani',
            'eu' => 'Basque',
            'be' => 'Belarusian',
            'bn' => 'Bengali',
            'bs' => 'Bosnian',
            'bg' => 'Bulgarian',
            'ca' => 'Catalan',
            'ceb' => 'Cebuano',
            'ny' => 'Chichewa',
            'zh-CN' => 'Chinese Simplified',
            'zh-TW' => 'Chinese Traditional',
            'co' => 'Corsican',
            'hr' => 'Croatian',
            'cs' => 'Czech',
            'da' => 'Danish',
            'nl' => 'Dutch',
            'en' => 'English',
            'eo' => 'Esperanto',
            'et' => 'Estonian',
            'tl' => 'Filipino',
            'fi' => 'Finnish',
            'fr' => 'French',
            'fy' => 'Frisian',
            'gl' => 'Galician',
            'ka' => 'Georgian',
            'de' => 'German',
            'el' => 'Greek',
            'gu' => 'Gujarati',
            'ht' => 'Haitian Creole',
            'ha' => 'Hausa',
            'haw' => 'Hawaiian',
            'iw' => 'Hebrew',
            'hi' => 'Hindi',
            'hmn' => 'Hmong',
            'hu' => 'Hungarian',
            'is' => 'Icelandic',
            'ig' => 'Igbo',
            'id' => 'Indonesian',
            'ga' => 'Irish',
            'it' => 'Italian',
            'ja' => 'Japanese',
            'jw' => 'Javanese',
            'kn' => 'Kannada',
            'kk' => 'Kazakh',
            'km' => 'Khmer',
            'ko' => 'Korean',
            'ku' => 'Kurdish',
            'ky' => 'Kyrgyz',
            'lo' => 'Lao',
            'la' => 'Latin',
            'lv' => 'Latvian',
            'lt' => 'Lithuanian',
            'lb' => 'Luxembourgish',
            'mk' => 'Macedonian',
            'mg' => 'Malagasy',
            'ms' => 'Malay',
            'ml' => 'Malayalam',
            'mt' => 'Maltese',
            'mi' => 'Maori',
            'mr' => 'Marathi',
            'mn' => 'Mongolian',
            'my' => 'Myanmar (Burmese)',
            'ne' => 'Nepali',
            'no' => 'Norwegian',
            'ps' => 'Pashto',
            'fa' => 'Persian',
            'pl' => 'Polish',
            'pt' => 'Portuguese',
            'ma' => 'Punjabi',
            'ro' => 'Romanian',
            'ru' => 'Russian',
            'sm' => 'Samoan',
            'gd' => 'Scots Gaelic',
            'sr' => 'Serbian',
            'st' => 'Sesotho',
            'sn' => 'Shona',
            'sd' => 'Sindhi',
            'si' => 'Sinhala',
            'sk' => 'Slovak',
            'sl' => 'Slovenian',
            'so' => 'Somali',
            'es' => 'Spanish',
            'su' => 'Sudanese',
            'sw' => 'Swahili',
            'sv' => 'Swedish',
            'tg' => 'Tajik',
            'ta' => 'Tamil',
            'te' => 'Telugu',
            'th' => 'Thai',
            'tr' => 'Turkish',
            'uk' => 'Ukrainian',
            'ur' => 'Urdu',
            'uz' => 'Uzbek',
            'vi' => 'Vietnamese',
            'cy' => 'Welsh',
            'xh' => 'Xhosa',
            'yi' => 'Yiddish',
            'yo' => 'Yoruba',
            'zu' => 'Zulu'
        );
    }
}