<?php
class ControllerExtensionModuleXGift extends Controller {
    use OCM\Traits\Front\Cart;
    use OCM\Traits\Front\Product_options;
    use OCM\Traits\Front\Crucify;
    private $mtype;
    private $ext_path;
    private $name = 'xgift';
    public function __construct($registry) {
        parent::__construct($registry);
        $this->registry = $registry;
        $this->ocm = ($ocm = $this->registry->get('ocm_front')) ? $ocm : new OCM\Front($this->registry);
        $this->mtype = 'module';
        $this->ext_path = 'extension/module/xgift';
    }
    /* load via module */
    public function index() {
        return '<div class="xg-module-wrapper"></div>';
    }
    public function skip() {
        $json = array();
        $json['success'] = true;
        $order_id = isset($this->session->data['order_id']) ? $this->session->data['order_id'] : 0;
        $this->session->data['xg_skip'] = $order_id;
        $this->response->addHeader('Content-Type: application/json');
        $this->response->setOutput(json_encode($json));
    }
    public function fetch() {
        $ext_lang = $this->load->language($this->ext_path);
        $this->load->model('catalog/product');
        $this->load->model($this->ext_path);
        $this->load->model('tool/image');

        $xgift_box = $this->ocm->getConfig('xgift_box', $this->mtype);
        $xgift_image_width = $xgift_box && $xgift_box['width'] ? $xgift_box['width'] : 180;
        $xgift_image_height = $xgift_box && $xgift_box['height'] ? $xgift_box['height'] : 180;

        $data = array();
        $data = array_merge($data, $ext_lang);
        $data['products'] = array();
        $results = $this->xgift->getActiveGift();
        
        $cart_gift = array();
        if ($results) {
            $this->xgift->clean($results['xgift_id'], $results['limit']);
            $cart_gift = $this->xgift->getCartGiftProducts($results['xgift_id']);
            if ($results['limit'] > count($cart_gift)) {
                foreach ($results['products'] as $product_id => $rate) {
                    $product_info =  $this->model_catalog_product->getProduct($product_id);
                    if (in_array($product_id, $cart_gift)) {
                        continue;
                    }
                    if (!$product_info['status']) {
                        continue;
                    }
                    /* Don't show out of stock products */
                    if ($product_info['quantity'] <= 0 && !$this->config->get('config_stock_checkout')) {
                        continue;
                    }
                    $original_price = isset($product_info['ocm_price']) ? (float)$product_info['ocm_price'] : (float)$product_info['price'];
                    // only consider OC special price for bundled product NOT from other mods
                    $product_special = $this->db->query("SELECT price FROM " . DB_PREFIX . "product_special WHERE product_id = '" . (int)$product_id . "' AND customer_group_id = '" . (int)$this->config->get('config_customer_group_id') . "' AND ((date_start = '0000-00-00' OR date_start < NOW()) AND (date_end = '0000-00-00' OR date_end > NOW())) ORDER BY priority ASC, price ASC LIMIT 1")->row;
                    $original_price = $product_special ? (float)$product_special['price'] : $original_price;
                    $price =  $this->xgift->getDiscountedPrice($original_price, $rate);
                    
                    $old_price = $this->currency->format($this->tax->calculate($original_price, $product_info['tax_class_id'], $this->config->get('config_tax')), $this->session->data['currency']);
                    $product_info['price'] = (float)$price;

                    if ($product_info['image']) {
                        $image = $this->model_tool_image->resize($product_info['image'], $xgift_image_width, $xgift_image_height);
                    } else {
                        $image = $this->model_tool_image->resize('placeholder.png', $xgift_image_width, $xgift_image_height);
                    }
                    $free = false;
                    if (!$product_info['price']) {
                        $price = $this->language->get('text_free');
                        $free = true;
                    }
                    else if ($this->customer->isLogged() || !$this->config->get('config_customer_price')) {
                        $price = $this->currency->format($this->tax->calculate($product_info['price'], $product_info['tax_class_id'], $this->config->get('config_tax')), $this->session->data['currency']);
                    } else {
                        $price = false;
                    }

                    $data['products'][] = array(
                        'product_id'  => $product_info['product_id'],
                        'name'        => $product_info['name'],
                        'thumb'       => $image,
                        'price'       => $price,
                        'old_price'   => $old_price,
                        'free'        => $free,
                        'href'        => $this->url->link('product/product', 'product_id=' . $product_info['product_id'])
                    );
                }
            }
        }
        $data['xgift_id'] = 0;
        $data['attention'] = '';
        if ($results && $data['products'] && $results['limit']) {
            $quantity =  $this->number2string($results['limit']);
            $data['attention'] = sprintf($this->language->get('text_choose_gift'), $quantity);
            $data['xgift_id'] = $results['xgift_id'];
            $avail = $results['limit'] - count($cart_gift);
            $data['avail_products'] = sprintf($this->language->get('text_avail_products'), $avail);
        }
        $data['date_js'] = isset($this->request->get['dp']) ? (int)$this->request->get['dp'] : 0;
        $data['mode'] = isset($xgift_box['mode']) ? $xgift_box['mode'] : 'popup';
        $this->response->setOutput($this->ocm->view($this->ext_path, $data));
    }
    public function sync() {
        $this->load->language($this->ext_path);
        $json = array(); 
        $json['success'] = true;
        $results = $this->xgift->getActiveGift();
        if ($results) {
            $json['gift'] = !!$results['xgift_id']; 
            $json['require'] = !!$results['require']; 
            $json['cart'] = $this->xgift->clean($results['xgift_id'], $results['limit']);
            $cart_gift = $this->xgift->getCartGiftProducts($results['xgift_id']);
            $json['avail'] = $results['limit'] - count($cart_gift);
            $json['title'] = $this->language->get('text_gift_title');
            // let's auto add if there is only one gift and it is free
            $products = $results['products'];
            if ($json['gift'] && $json['avail'] && count($products) == 1) {
                foreach ($products as $product_id => $rate) {} // old php version does support pick
                if ($product_id && $rate['percent'] && $rate['value'] == 1) {
                    $this->load->model('catalog/product');
                    $product_options = $this->model_catalog_product->getProductOptions($product_id);
                    if (!$product_options) {
                        $option = array();
                        $option['xgift'] = $results['xgift_id'];
                        $this->cart->add($product_id, $json['avail'], $option);
                        $json['gift'] = false;
                        $json['cart'] = true;
                        $json['avail'] = 0;
                    }
                }
            }
            // display suggestion
            $json['suggestion'] = $this->getGiftSuggestion($results);
        }
        $this->response->addHeader('Content-Type: application/json');
        $this->response->setOutput(json_encode($json)); 
    }
    public function addToCart() {
        $json = array(); 
        $this->load->model('catalog/product');
        $this->load->language('checkout/cart');
        $this->load->language($this->ext_path);
        $this->load->model($this->ext_path);
        
        $xgift_id = isset($this->request->post['xgift_id']) ? $this->request->post['xgift_id'] : 0;
        $product_id = isset($this->request->post['product_id']) ? (int)$this->request->post['product_id'] : 0;
        $recurring_id = isset($this->request->post['recurring_id']) ? (int)$this->request->post['recurring_id'] : 0;
        $option = isset($this->request->post['option']) ? $this->request->post['option'] : array();
        $product_info = $this->model_catalog_product->getProduct($product_id);

        if ($product_info && $this->xgift->isValidGiftProduct($product_id, $xgift_id)) {
            $json = $this->isValidateCart($product_id, $option, $recurring_id);
            if (!$json && $xgift_id) {
                $option['xgift'] = $xgift_id;
                $this->cart->add($product_id, 1, $option, $recurring_id);
                $json = $this->refreshCart($product_info);
            }
            $xgift = $this->xgift->getGiftById($xgift_id);
            $cart_gift = $this->xgift->getCartGiftProducts($xgift_id);
            $json['avail'] = $xgift['limit'] - count($cart_gift);
            $json['text'] = sprintf($this->language->get('text_avail_products'), $json['avail']);
        }
        $this->response->addHeader('Content-Type: application/json');
        $this->response->setOutput(json_encode($json)); 
    }
    public function getShortcode($option) {
        $ext_lang = $this->load->language($this->ext_path);
        $this->load->model($this->ext_path);
        $this->load->model('catalog/product');
        $this->load->model('tool/image');
        $data = array();
        $data = array_merge($data, $ext_lang);
        $number_to_text = array(
            '1' => $this->language->get('text_one'),
            '2' => $this->language->get('text_two'),
            '3' => $this->language->get('text_three'),
            '4' => $this->language->get('text_four'),
            '5' => $this->language->get('text_five'),
        );

        $xgift_box = $this->ocm->getConfig('xgift_box', $this->mtype);
        $xgift_image_width = $xgift_box && $xgift_box['width'] ? $xgift_box['width'] : 100;
        $xgift_image_height = $xgift_box && $xgift_box['height'] ? $xgift_box['height'] : 100;
        $text_avail_gift = $this->language->get('text_avail_gift');
        $param_avail_gift = substr_count($text_avail_gift, '%s');
        // current gift status
        $current = $this->xgift->getActiveGift();
        $data['suggestion'] = $this->getGiftSuggestion($current);
        $data['xgift_id'] = $current && $current['products'] ? $current['xgift_id'] : 0;
        $avail = false;
        if ($data['xgift_id']) {
            $cart_gift = $this->xgift->getCartGiftProducts($current['xgift_id']);
            $avail = $current['limit'] - count($cart_gift) > 0;
        }

        // gift restriction
        if ($this->customer->isLogged()) {
            $customer_group_id = $this->customer->getGroupId();
        } else if(isset($this->session->data['customer']) && isset($this->session->data['customer']['customer_group_id']) && $this->session->data['customer']['customer_group_id']) {
            $customer_group_id = $this->session->data['customer']['customer_group_id'];
        } else {
            $customer_group_id = 0;
        }
        $compare_with = array();
        $compare_with['store_id'] = $this->config->get('config_store_id');
        $compare_with['customer_group_id'] = $customer_group_id;
        $compare_with['time'] = date('G');
        $compare_with['date'] = date('Y-m-d');
        $compare_with['day'] = date('w');
        $_rules = array('store', 'customer_group', 'time', 'date', 'date_time', 'days');

        // gift product list
        $data['gifts'] = array();
        $result = $this->xgift->getGifts();
        $xgifts = $result['xmethods'];
        if ($xgifts) {
           $sort_order = array();
           foreach($xgifts as $xgift) {
              $sort_order[] = $xgift['start'];
           }
           array_multisort($sort_order, SORT_ASC, $xgifts);
           foreach($xgifts as $xgift) {
                $rules = $xgift['rules'];
                foreach(array_keys($rules) as $key) {
                    if (!in_array($key, $_rules)) {
                        unset($rules[$key]);
                    }
                }
                $alive_or_dead = $this->_crucify($rules, $compare_with);
                if (!$alive_or_dead['status']) {
                    continue;
                }

                $_xgift = array();
                $limit = (int)$xgift['limit'];
                $start = (float)$xgift['start'];
                $end = (float)$xgift['end'];

                $quantity =  $limit > 5 ? $limit : $number_to_text[$limit];
                $start = $this->currency->format($start, $this->session->data['currency']);
                $end = $this->currency->format($end, $this->session->data['currency']);
                if ($param_avail_gift == 3) {
                    $_xgift['heading'] = sprintf($text_avail_gift, $start, $start, $quantity);
                } else {
                    $_xgift['heading'] = sprintf($text_avail_gift, $start, $quantity);
                }
                $offer_info = $this->model_extension_module_xgift->getCombinationDesc($xgift['xgift_id']);
                if ($offer_info['title']) {
                    $_xgift['heading'] = $offer_info['title'];
                }
                $_xgift['desc'] = $offer_info['desc'];
                foreach ($xgift['products'] as $product_id => $rate) {
                    $product_info =  $this->model_catalog_product->getProduct($product_id);
                    if (!$product_info['status']) {
                        continue;
                    }
                    /* Don't show out of stock products */
                    if ($product_info['quantity'] <= 0 && !$this->config->get('config_stock_checkout')) {
                        continue;
                    }
                    $original_price = isset($product_info['ocm_price']) ? (float)$product_info['ocm_price'] : (float)$product_info['price'];
                    // only consider OC special price for bundled product NOT from other mods
                    $product_special = $this->db->query("SELECT price FROM " . DB_PREFIX . "product_special WHERE product_id = '" . (int)$product_id . "' AND customer_group_id = '" . (int)$this->config->get('config_customer_group_id') . "' AND ((date_start = '0000-00-00' OR date_start < NOW()) AND (date_end = '0000-00-00' OR date_end > NOW())) ORDER BY priority ASC, price ASC LIMIT 1")->row;
                    $original_price = $product_special ? (float)$product_special['price'] : $original_price;
                    $price =  $this->xgift->getDiscountedPrice($original_price, $rate);
                    
                    $old_price = $this->currency->format($this->tax->calculate($original_price, $product_info['tax_class_id'], $this->config->get('config_tax')), $this->session->data['currency']);
                    $product_info['price'] = (float)$price;

                    if ($product_info['image']) {
                        $image = $this->model_tool_image->resize($product_info['image'], $xgift_image_width, $xgift_image_height);
                    } else {
                        $image = $this->model_tool_image->resize('placeholder.png', $xgift_image_width, $xgift_image_height);
                    }
                    $free = false;
                    if (!$product_info['price']) {
                        $price = $this->language->get('text_free');
                        $free = true;
                    }
                    else if ($this->customer->isLogged() || !$this->config->get('config_customer_price')) {
                        $price = $this->currency->format($this->tax->calculate($product_info['price'], $product_info['tax_class_id'], $this->config->get('config_tax')), $this->session->data['currency']);
                    } else {
                        $price = false;
                    }

                    $_xgift['products'][] = array(
                        'product_id'  => $product_info['product_id'],
                        'name'        => $product_info['name'],
                        'thumb'       => $image,
                        'price'       => $price,
                        'old_price'   => $old_price,
                        'free'        => $free,
                        'availed'     => $avail && $current && $current['products'] && $current['xgift_id'] == $xgift['xgift_id'],
                        'href'        => $this->url->link('product/product', 'product_id=' . $product_info['product_id'])
                    );
                }
                $data['gifts'][] = $_xgift;
            }
        }
        $data['custom_css'] = $this->model_extension_module_xgift->getCSS($xgift_box);
        return $this->ocm->view('extension/module/xgift_offer', $data);
    }
    private function getGiftSuggestion($offer) {
        $suggestion = '';
        $xgift_show_message = $this->ocm->getConfig('xgift_show_message', $this->mtype);
        $xgift_message_offset = (float)$this->ocm->getConfig('xgift_message_offset', $this->mtype);
        if (!$xgift_message_offset) $xgift_message_offset = PHP_INT_MAX;
        if ($xgift_show_message 
            && !$offer['products'] 
            && $offer['require']
            && $xgift_message_offset > $offer['require']['diff']) {
            $quantity =  $this->number2string($offer['require']['limit']);
            $amount = $this->currency->format($offer['require']['diff'], $this->session->data['currency']);
            $suggestion = sprintf($this->language->get('text_to_get_gift'), $amount, $quantity);
        }
        return $suggestion;
    }
    private function number2string($number) {
        $number_to_text = array(
            '1' => $this->language->get('text_one'),
            '2' => $this->language->get('text_two'),
            '3' => $this->language->get('text_three'),
            '4' => $this->language->get('text_four'),
            '5' => $this->language->get('text_five'),
        );
        $return =  $number > 5 ? $number : $number_to_text[$number];
        return '<span class="xg-gift-qnty">' . $return . '</span>';
    }
 }