<?php
class ControllerExtensionModuleXGift extends Controller {
    use OCM\Traits\Back\Controller\Common;
    use OCM\Traits\Back\Controller\Crud;
    use OCM\Traits\Back\Controller\Product;
    use OCM\Traits\Back\Controller\Util;
    private $ext_path;
    private $ext_key;
    private $error = array();
    private $ocm;
    private $meta = array(
        'id'       => '37488',
        'type'     => 'module',
        'name'     => 'xgift',
        'path'     => 'extension/module/',
        'title'    => 'X-Gift',
        'version'  => '2.0.4',
        'ocmod'    => true,
        'event'    => true
    );
     /* Config with default values  Special keyword __LANG__ denotes array of languages e.g 'name' => array('__LANG__' => 'xyz') */
    private $setting = array(
        'xgift_status' => '',
        'xgift_text' => array('__LANG__' => 'Gift Product'),
        'xgift_box' => array(
            'width'       => 180,
            'height'      => 180,
            'bg_color'    => '#239dce',
            'font_color'  => '#ffffff',
            'css'         => '',
            'close'       => true,
            'mode'        => 'popup'
        ),
        'xgift_show_message'   => '',
        'xgift_message_offset' => ''
    );
    private $events = array(
        array(
            'trigger' => 'admin/view/common/column_left/before',
            'action'  => 'extension/module/xgift/onColumnLeft'
        )
    );
    private $tables = array(
        'xgift' => array()
    );
    public function __construct($registry) {
        parent::__construct($registry);
        $this->ocm = new OCM\Back($registry, $this->meta);
        $this->ext_path = $this->meta['path'] . $this->meta['name'];
        $this->ext_key = 'model_' . str_replace('/', '_', $this->ext_path);
    }
    public function index() {
        $ext_lang = $this->load->language($this->ext_path);
        $this->load->model($this->ext_path);
        $this->document->setTitle($this->language->get('heading_title'));
        $this->load->model('setting/setting');

        /* Some help lang modificaiton */
        $ext_lang['help_time'] = sprintf($this->language->get('help_time'), date('h:i:s A'));
        $ext_lang['help_date'] = sprintf($this->language->get('help_date'), date('Y-m-d'));
        //$ext_lang['more_equation'] = true; // will replace by placeholder 

        $data = array();
        $data = array_merge($data, $ext_lang);

        /* লাইসেন্স বেরিফিকেসন  */
        $rs = $this->ocm->rpd();
        $data['_v'] = $rs ? '' : $this->ocm->vs();
        /* লাইসেন্স শেষ */
        $this->ocm->checkOCMOD();
        $this->upgrade();

        if (($this->request->server['REQUEST_METHOD'] == 'POST') && $this->validate()) {
            $this->session->data['success'] = $this->language->get('text_success');
            $this->response->redirect($this->ocm->url->getExtensionsURL());
        }

        $data['heading_title'] = $this->language->get('heading_title');
        $data['x_name'] = $this->meta['name'];
        $data['x_path'] = $this->meta['path'] . $this->meta['name'];
             
       if (isset($this->error['warning'])) {
            $data['error_warning'] = $this->error['warning'];
        } else {
            $data['error_warning'] = '';
        }
        if (isset($this->session->data['warning'])) {
            $data['error_warning'] = $this->session->data['warning'];
            unset($this->session->data['warning']);
        }
        if (isset($this->session->data['success'])) {
            $data['success'] = $this->session->data['success'];
            unset($this->session->data['success']);
        } else {
            $data['success'] = '';
        }

        $data['breadcrumbs'] = array();
        $data['breadcrumbs'][] = array(
            'text' => $this->language->get('text_home'),
            'href' => $this->ocm->url->link('common/dashboard', '', true)
        );
        $data['breadcrumbs'][] = array(
            'text' => $this->language->get('text_extension'),
            'href' => $this->ocm->url->getExtensionsURL()
        );
        $data['breadcrumbs'][] = array(
            'text' => $this->language->get('heading_title'),
            'href' => $this->ocm->url->getExtensionURL()
        );

        $data['action'] = $this->ocm->url->getExtensionURL();
        $data['cancel'] = $this->ocm->url->getExtensionsURL();
        
        
        $data['method_data'] = $this->{$this->ext_key}->getData();

        $this->load->model('setting/store');
        $data['stores'] = $this->model_setting_store->getStores();
        $data['stores']=  array_merge(array(array('store_id'=>0,'name'=>$this->language->get('store_default'))),$data['stores']);
                
        $cg_path = (VERSION >= '2.1.0.1') ? 'customer' : 'sale';
        $this->load->model($cg_path . '/customer_group');
        $data['customer_groups'] = $this->{'model_' . $cg_path . '_customer_group'}->getCustomerGroups();
        $data['customer_groups'][] = array('customer_group_id' => 0, 'name' => $this->language->get('text_guest_checkout'));

        $this->load->model('localisation/language');
        $languages = $this->model_localisation_language->getLanguages();
        $data['languages'] = $this->ocm->url->getLangImage($languages);
        $data['language_id'] = $this->config->get('config_language_id');

        /* All required options */
        $options = array();

        $this->load->model('setting/store');
        $stores = $this->model_setting_store->getStores();
        array_unshift($stores, array('store_id' => 0,'name' => $this->language->get('text_store_default')));
        $options['store'] = $this->ocm->form->getOptions($stores, 'store_id');
      
        $cg_path = (VERSION >= '2.1.0.1') ? 'customer' : 'sale';
        $this->load->model($cg_path . '/customer_group');
        $customer_groups = $this->{'model_' . $cg_path . '_customer_group'}->getCustomerGroups();
        $customer_groups[] = array('customer_group_id' => 0, 'name' => $this->language->get('text_guest_checkout'));
        $options['customer_group'] = $this->ocm->form->getOptions($customer_groups, 'customer_group_id');

        $status_options = array('1' => $data['text_enabled'], '0' => $data['text_disabled']);
        $options['status'] = $this->ocm->form->getOptions($status_options, 'none');

        $mode_options = array(
            'popup'   => $data['text_mode_popup'],
            'inline'  => $data['text_mode_inline']
        );
        $options['box_mode'] = $this->ocm->form->getOptions($mode_options, 'none');

        $product_rule_options = array(
            '' => $data['text_any'],
            '6' => $data['text_ones_any'],
            '3' => $data['text_ones_any_with_other'],
            '4' => $data['text_ones_must'],
            '2' => $data['text_ones_must_with_other'],
            '5' => $data['text_ones_except'],
            '7' => $data['text_ones_except_with_other'] 
        );
        $product_rule_options = $this->ocm->form->getOptions($product_rule_options, 'none');
        $options['category'] = $options['product'] = $options['option'] = $options['manufacturer_rule'] = $options['location_rule'] = $product_rule_options; 

        $modes = array(
            '0' => $data['text_mode_and'],
            '1' => $data['text_mode_or']
        );
        $options['product_or'] = $this->ocm->form->getOptions($modes, 'none');

        $range_options = array(
            'sub'           => $data['text_range_sub_total'],
            'total'         => $data['text_range_total'],
            'sub_special'   => $data['text_percent_sub_special'],
            'total_special' => $data['text_percent_total_special']
        );
        $options['range_type'] = $this->ocm->form->getOptions($range_options, 'none');

        $option_price_options = array(
            'none'   => $data['text_no_option_discount'],
            'all'    => $data['text_all_option_discount'],
            'some'   => $data['text_some_option_discount']
        );
        $options['option_price'] = $this->ocm->form->getOptions($option_price_options, 'none');

        $week_day_optios = array(
            '0' => $data['text_sunday'],
            '1' => $data['text_monday'],
            '2' => $data['text_tuesday'],
            '3' => $data['text_wednesday'],
            '4' => $data['text_thursday'],
            '5' => $data['text_friday'],
            '6' => $data['text_saturday']
        );
        $options['days'] = $this->ocm->form->getOptions($week_day_optios, 'none');
        /* set form data */
        $this->ocm->form->setLangs($ext_lang)->setOptions($options);

        $more_help = array();
        //$more_help['dimensional_factor'] = $data['more_dimensional_factor'];
        $data['more_help'] = json_encode($more_help);
        
        $data['oc_3_1'] = VERSION >= '3.1.0.0';
        $data['editor_js'] = VERSION >= '2.3.0.0';
        $data['global'] = $this->getConfigForm($data);
        $data['tpl'] = json_encode(array(
            'method' => $this->getFormData($data, true)
        ));
        
        $data['methods']=$this->getMethodList($data['method_data']);
        $data['form_data']=$this->getFormData($data);
    
        $data['header'] = $this->load->controller('common/header');
        $data['column_left'] = $this->load->controller('common/column_left');
        $data['footer'] = $this->load->controller('common/footer');
        
        $this->response->setOutput($this->ocm->view($this->ext_path, $data));
    }
    private function getConfigForm($data) {
        /* Set base name for form inputs */
        $setting = $this->ocm->setting->getSetting($this->setting, $data['languages']);

        $this->ocm->form->setBasename($this->ocm->prefix . 'xgift_', 'prefix');
        $this->ocm->form->setPreset($setting)->setIDPostfix('');

        $return = '';
        $tabs = array(
            'global-general' => $data['tab_global_general'],
            'global-integration' => $data['tab_integration'],
            'global-text' => $data['tab_text'],
            'global-help' => $data['tab_help']
        );
        $return .= $this->ocm->misc->getTabs('global-tab', $tabs);
        $return .= '<div class="tab-content">';

        $return .= '<div class="tab-pane active" id="global-general">';
        $return .= $this->ocm->form->get('checkbox', array('name' => 'show_message', 'label' => $data['text_show_message']));
        $return .= $this->ocm->form->get('input', 'message_offset');
        $return .= $this->ocm->form->get('checkbox', array('name' => 'box[close]', 'label' => $data['text_show_close']));
        $return .= $this->ocm->form->get('select', array('name' => 'status', 'title' => $data['entry_module_status'], 'help' => $data['help_module_status']));
        $return .= '</div>';

        $return .= '<div class="tab-pane" id="global-integration">';
        $return .= $this->ocm->form->get('radio', 'box[mode]');
        $return .= $this->ocm->form->get('input', 'box[width]');
        $return .= $this->ocm->form->get('input', 'box[height]');

        $return .= $this->ocm->form->get('input', array('name' => 'box[bg_color]', 'type' => 'color'));
        $return .= $this->ocm->form->get('input', array('name' => 'box[font_color]', 'type' => 'color'));
        $return .= $this->ocm->form->get('textarea', 'box[css]');

        $element = $this->ocm->misc->getHelpTag($data['help_shortcode']);
        $return .= $this->ocm->form->get('bare', array('name' => 'shortcode', 'title' => '', 'label_col' => 0, 'element' => $element));

        $return .= '</div>';

        $return .= '<div class="tab-pane" id="global-text">'; 
        $return .= $this->ocm->misc->getLangTabs('text', $data['languages']);
        $active = ' active';
        $return .= '<div class="tab-content">';
        foreach ($data['languages'] as $language) { 
            $language_id = $language['language_id'];
            $return .= '<div class="tab-pane' . $active . '" id="text-' . $language_id . '">';
            $return .= $this->ocm->form->get('input', 'text[' . $language_id . ']');
            $return .= '</div>';
            $active = '';
        }
        $return .= '</div>';
        $return .= '</div>';

        $return .= '<div class="tab-pane" id="global-help">';
        $return .= $this->ocm->misc->getOCMInfo();
        $return .= '</div>';
        $return .= '</div>';
        return $return;
    }
    private function getFormData($data, $new_tab = false) {
       $this->load->model('catalog/category');
       $this->load->model('catalog/product');
       $this->load->model('catalog/manufacturer');
       $this->load->model('catalog/option');
       if ($new_tab) {
            $data['method_data'] = array(
                array('tab_id' => '__INDEX__', 'method_data' => array())
            );
        }
        /* Set base name for form inputs */
        $this->ocm->form->setBasename($this->meta['name']);
        $fields_all = array(
            'store'          => 'store_all',
            'customer_group' => 'customer_group_all',
            'days'           => 'days_all'
        );
        $default_values = $this->getDefaultValues();
        $return = '';
        foreach($data['method_data'] as $single_method) {
            $no_of_tab   = $single_method['tab_id'];
            $method_data = $single_method['method_data'];
            $method_data = $this->resetEmptyAll($method_data, $fields_all);
            $method_data = array_merge($default_values, $method_data);
            if (!$method_data['display']) {
                $method_data['display'] = 'Untitled Gift';
            }
            
            $this->ocm->form->setPreset($method_data)->setIDPostfix($no_of_tab);

            $return .= '<div id="ocm-method-'.$no_of_tab.'" class="tab-pane xgift ocm-method">';
            $return .= '<div class="ocm-action-btn">';
            $return .= $this->ocm->misc->getButton(array('type' => 'warning', 'help'=> $data['text_method_copy'], 'class' => 'btn-ocm-copy btn-sm', 'icon' => 'fa-copy'));
            $return .= $this->ocm->misc->getButton(array('type' => 'danger', 'help'=> $data['text_method_remove'], 'class' => 'btn-ocm-delete btn-sm', 'icon' => 'fa-trash fa-trash-alt'));
            $return .= '</div>';

            $return .= $this->ocm->form->get('input', 'display');

            $tabs = array(
                'common_' . $no_of_tab      => $data['tab_general'],
                'criteria_' . $no_of_tab    => $data['tab_criteria_setting'],
                'catprod_' . $no_of_tab     => $data['tab_category_product'],
                'products_' . $no_of_tab    => $data['tab_gift_product'],
                'description_' . $no_of_tab => $data['tab_offer_desc']
            );
            $return .= $this->ocm->misc->getTabs('method-tab' . $no_of_tab, $tabs);

            $return .= '<div class="tab-content">';
            $return .= '<div class="tab-pane active" id="common_' . $no_of_tab . '">';
            $return .= $this->ocm->form->get('select', 'status'); 
            $return .= '</div>';

            $return .= '<div class="tab-pane" id="criteria_'.$no_of_tab.'">';
            $return .= $this->ocm->form->get('select', 'range_type');
            $return .= $this->ocm->form->get('checkbox', array('name' => 'method_specific', 'label' => $data['text_method_specific']));
            $return .= $this->ocm->form->get('range', 'range');
            $return .= $this->ocm->form->get('checkgroup', 'store[]');
            $return .= $this->ocm->form->get('checkgroup', 'customer_group[]');
            $return .= $this->ocm->form->get('checkgroup', 'days[]');
            $return .= $this->ocm->form->get('range', array('name' => 'time', 'type' => 'time'));
            $return .= $this->ocm->form->get('range', array('name' => 'date', 'type' => 'date'));
            $return .= '</div>';
            $return .= '<div class="tab-pane" id="catprod_'.$no_of_tab.'">';

            /* categories */
            $categories = array();
            foreach ($method_data['product_category'] as $category_id) {
               $category_info = $this->model_catalog_category->getCategory($category_id);
                if ($category_info) {
                    if ($category_info['path']) $category_info['path'] .=  '&nbsp;&nbsp;&gt;&nbsp;&nbsp;';
                    $categories[] = array(
                        'category_id' => $category_id,
                        'name'       => $category_info['path'].$category_info['name']
                    );
                }
            }

            $visible = (int)$method_data['category'] > 1;
            $return .= $this->ocm->form->get('select', 'category');
            $param = array(
                'name'  => 'product_category[]',
                'options' => $this->ocm->form->getOptions($categories, 'category_id'),
                'attr'  => 'category',
                'browser' => 'category',
                'visible' => $visible
            );
            $return .= $this->ocm->form->get('autofill', $param);

            /* Products  */
            $products = array();
            foreach ($method_data['product_product'] as $product_id) {
               $product_info = $this->model_catalog_product->getProduct($product_id);
               if ($product_info) {
                    $products[] = array(
                        'product_id' => $product_id,
                        'name'       => $product_info['name']
                    );
               }
            }
            
            $visible = (int)$method_data['product'] > 1;
            $return .= $this->ocm->form->get('select', 'product');
            $param = array(
                'name'  => 'product_product[]',
                'options' => $this->ocm->form->getOptions($products, 'product_id'),
                'attr'  => 'product',
                'browser' => 'product',
                'visible' => $visible
            );
            $return .= $this->ocm->form->get('autofill', $param);

            /* Manufacturer  */
            $manufacturers = array();
            foreach ($method_data['manufacturer'] as $manufacturer_id) {
                $manufacturer_info = $this->model_catalog_manufacturer->getManufacturer($manufacturer_id);
                if ($manufacturer_info) {
                    $manufacturers[] = array(
                        'manufacturer_id' => $manufacturer_id,
                        'name'            => $manufacturer_info['name']
                    );
                }
            }

            $visible = (int)$method_data['manufacturer_rule'] > 1;
            $return .= $this->ocm->form->get('select', 'manufacturer_rule');
            $param = array(
                'name'    => 'manufacturer[]',
                'options' => $this->ocm->form->getOptions($manufacturers, 'manufacturer_id'),
                'attr'    => 'manufacturer_rule',
                'browser' => 'manufacturer',
                'visible' => $visible
            );
            $return .= $this->ocm->form->get('autofill', $param);
            $return .= $this->ocm->form->get('select', 'product_or');
            $return .= '</div>';
            $return .= '<div class="tab-pane" id="products_'.$no_of_tab.'">';
            $return .= $this->ocm->form->get('input', 'limit');
            $return .= $this->ocm->form->get('select', 'option_price');
             /* Product Options  */
            $discount_option = array();
            foreach ($method_data['discount_option'] as $option_value_id) {
               $option_value_info = $this->model_catalog_option->getOptionValue($option_value_id);
               if ($option_value_info) {
                    $option_info = $this->model_catalog_option->getOption($option_value_info['option_id']);
                    if ($option_info) {
                        $discount_option[] = array(
                            'option_value_id' => $option_value_id,
                            'name'            => strip_tags(html_entity_decode($option_info['name'], ENT_QUOTES, 'UTF-8')).'&nbsp;&nbsp;&gt;&nbsp;&nbsp;' . strip_tags(html_entity_decode($option_value_info['name'], ENT_QUOTES, 'UTF-8'))
                        );
                    }
               }
            }
            $param = array(
                'name'    => 'discount_option[]',
                'options' => $this->ocm->form->getOptions($discount_option, 'option_value_id'),
                'attr'    => 'option',
                'browser' => 'option_value',
                'class'   => 'option_price ocm-hide some',
                'visible' => $method_data['option_price'] == 'some'
            );
            $return .= $this->ocm->form->get('autofill', $param);

            $element = $this->getRanges($method_data, $data);
            $return .= $this->ocm->form->get('bare', array('name' => 'products', 'label_col' => 0, 'element' => $element));
            $return .= '</div>';
            /* End of product tab  */

            $return .= '<div class="tab-pane" id="description_' . $no_of_tab . '">';
            $return .= $this->ocm->misc->getLangTabs('language_' . $no_of_tab, $data['languages']);
            $active = ' active';
            $return .= '<div class="tab-content">';
            foreach ($data['languages'] as $language) { 
                $language_id = $language['language_id'];
                $return .= '<div class="tab-pane' . $active . '" id="language_' . $no_of_tab . '-' . $language_id . '">';
                $return .= $this->ocm->form->get('textarea', 'title[' . $language_id . ']');

                $param = array(
                    'name'  => 'desc[' . $language_id . ']',
                    'id'    => 'desc_' . $language_id . '_',
                    'class' => 'editor',
                    'rows'  => 10
                );
                $return .= $this->ocm->form->get('textarea', $param);

                $return .= '</div>';
                $active = '';
            }
            $return .= '</div>';
            $return .= '</div>';
            /* offer description */

            $return .= '</div>';
            $return .= '</div>';
        }
        return $return;
    }
    private function getRanges($method_data, $data) {
        $return = '';
        $return .='<div class="ocm-range-container">
                    <div class="ocm-range-option">';
        $return .= '<div class="bulk-input"><input type="text" value="" placeholder="' . $data['text_adjust_bulk'] .'" class="form-control adjust-bulk" autocomplete="off"></div>';
        $return .= $this->ocm->misc->getButton(array('type' => 'primary', 'title' => $data['text_add_new'], 'class' => 'add-ocm-row btn-sm range-btn', 'icon' => 'fa-plus-circle'));
        $return .=     $this->ocm->misc->getButton(array('type' => 'danger', 'title'=> $data['text_delete_all'], 'class' => 'ocm-row-remove-all btn-sm range-btn'));
        $return .= '</div>';

        $product_ids = array();
        foreach ($method_data['products'] as $product_id => $price) { 
            $product_ids[] = $product_id;
        }

        $products = $this->{$this->ext_key}->getBatchProducts($product_ids);
        $table_body = '';
        foreach ($method_data['products'] as $product_id => $price) { 
           if (isset($products[$product_id])) {
                $table_body .= ' <tr rel="'.$product_id.'">' 
                    .'<td class="text-left">'.$products[$product_id]['name'].'</td>'
                    .'<td class="text-left">'.$products[$product_id]['price'].'</td>'
                    .'<td class="text-left"><input size="15" type="text" class="form-control product" price="'.$products[$product_id]['price'].'" rel="'.$product_id.'" name="xgift[products]['.$product_id.']" value="'.$price.'" /></td>'
                    .'<td class="text-right"><a class="btn btn-sm btn-danger ocm-row-remove">'.$data['text_remove'].'</a></td>'
                .'</tr>';
            }
        }
        if (!$products) {
            $table_body .='<tr class="no-row"><td colspan="4">'.$data['text_no_unit_row'].'</td></tr>';
        }

        $table_headings = array(
            array(
                'title'  => $data['text_product_name']
            ),
            array(
                'title'  => $data['text_product_price']
            ),
            array(
                'title'  => $data['text_gift_price']
            ),
            array(
                'title'  => $data['text_action']
            )
        );

        $return .= $this->ocm->misc->getTableSkeleton($table_headings, $table_body);
        $return .= '</div>';
        return $return;
    }
    private function getDefaultValues() {
        return array(
           /* array rules */ 
           'display'            => 'Untitled Gift',
           'customer_group'     => array(),
           'store'              => array(),
           'days'               => array(),
           'rate_start'         => array(),
           'rate_end'           => array(),
           'products'           => array(),
           'product_category'   => array(),
           'product_product'    => array(),
           'manufacturer'       => array(),
           'discount_option'    => array(),
           /* string rules*/
           'status'             => 1,
           'range_type'         => 'sub',
           'no_special'         => '',
           'range_start'        => '',
           'range_end'          => '',
           'limit'              => 1,
           'store_all'          => '',
           'customer_group_all' => '',
           'days_all'           => '',
           'time_start'         => '',
           'time_end'           => '',
           'rate_type'          => '',
           'date_start'         => '',
           'date_end'           => '',
           'category'           => '',
           'product'            => '',
           'manufacturer_rule'  => '',
           'method_specific'    => '',
           'option_price'       => 'none'
        );
    }
    /* admin events */
    public function onColumnLeft($route, &$data) {
        if (VERSION >= '2.3.0.0' && $this->user->hasPermission('access', $this->ext_path)) {
            $menu = array(
                'id'       => 'menu-xgift',
                'icon'     => 'fa fa-gift', 
                'name'     => $this->meta['title'],
                'href'     => $this->ocm->url->getExtensionURL(),
                'children' => array()
            );
            array_push($data['menus'], $menu);
        }
    }
}